/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeBackend;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeClient;
import com.metaeffekt.artifact.analysis.scancode.ScanRequestResponse;
import com.metaeffekt.artifact.analysis.scancode.ThrowingStrategy;
import com.metaeffekt.artifact.analysis.scancode.UUIDNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ScanCodeHttpClient
implements ScanCodeClient {
    private final ScanCodeBackend backend;
    private final ThrowingStrategy<ScanCodeHttpClient, ScanRequestResponse, Boolean, IOException> fileTimeoutStrategy;

    public ScanCodeHttpClient(ScanCodeBackend backend, ThrowingStrategy<ScanCodeHttpClient, ScanRequestResponse, Boolean, IOException> fileTimeoutStrategy) {
        this.backend = backend;
        this.fileTimeoutStrategy = fileTimeoutStrategy;
    }

    public ScanCodeHttpClient(ScanCodeBackend backend) {
        this.backend = backend;
        this.fileTimeoutStrategy = (client, response) -> FileUtils.waitFor((File)new File(response.getOutput_file()), (int)30);
    }

    @Override
    public ScanRequestResponse scan(String scanPath, String outputFile) throws IOException {
        FileUtils.deleteQuietly((File)new File(outputFile));
        ScanRequestResponse scanRequestResponse = this.backend.scan(scanPath, outputFile);
        if (this.fileTimeoutStrategy.apply(this, scanRequestResponse).booleanValue()) {
            return scanRequestResponse;
        }
        throw new FileNotFoundException(String.format("File %s could not be found until timeout.", scanRequestResponse.getOutput_file()));
    }

    public boolean isScanRunning(UUID uuid) throws IOException, UUIDNotFoundException {
        return this.backend.isRunning(uuid);
    }
}

