/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedConciseBitmap;
import com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;

public class ConciseBitmapFactoryTest {
    @Test
    public void testUnwrapWithNull() throws Exception {
        ConciseBitmapFactory factory = new ConciseBitmapFactory();
        ImmutableBitmap bitmap = factory.union(Iterables.transform((Iterable)Lists.newArrayList((Object[])new WrappedConciseBitmap[]{new WrappedConciseBitmap()}), (Function)new Function<WrappedConciseBitmap, ImmutableBitmap>(){

            public ImmutableBitmap apply(WrappedConciseBitmap input) {
                return null;
            }
        }));
        Assert.assertEquals((int)0, (int)bitmap.size());
    }

    @Test
    public void testUnwrapMerge() throws Exception {
        ConciseBitmapFactory factory = new ConciseBitmapFactory();
        WrappedConciseBitmap set = new WrappedConciseBitmap();
        set.add(1);
        set.add(3);
        set.add(5);
        ImmutableBitmap bitmap = factory.union(Arrays.asList(factory.makeImmutableBitmap((MutableBitmap)set), null));
        Assert.assertEquals((int)3, (int)bitmap.size());
    }

    @Test
    public void testGetOutOfBounds() {
        ConciseSet conciseSet = new ConciseSet();
        ImmutableSet ints = ImmutableSet.of((Object)0, (Object)4, (Object)9);
        Iterator i$ = ints.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            conciseSet.add(i);
        }
        WrappedImmutableConciseBitmap immutableBitmap = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)conciseSet));
        WrappedConciseBitmap mutableBitmap = new WrappedConciseBitmap(conciseSet);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)Integer.toString(i), (boolean)ints.contains(i), (boolean)mutableBitmap.get(i));
            Assert.assertEquals((String)Integer.toString(i), (boolean)ints.contains(i), (boolean)immutableBitmap.get(i));
        }
    }
}

