/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import com.metamx.collections.bitmap.BitmapBenchmark;
import com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import com.metamx.collections.bitmap.WrappedImmutableRoaringBitmap;
import com.metamx.test.annotation.Benchmark;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.util.BitSet;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

@Category(value={Benchmark.class})
@BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20)
public class RangeBitmapBenchmarkTest
extends BitmapBenchmark {
    public static final double DENSITY = 0.001;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareRandomRanges() throws Exception {
        System.setProperty("jub.customkey", String.format("%06.5f", 0.001));
        RangeBitmapBenchmarkTest.reset();
        BitSet expectedUnion = new BitSet();
        for (int i = 0; i < 10000; ++i) {
            int k;
            int runLength;
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            boolean fill = true;
            for (k = 0; k < 500000; k += runLength) {
                runLength = 500 + rand.nextInt(500);
                for (int j = k; fill && j < 500000 && j < k + runLength; ++j) {
                    c.add(j);
                    r.add(j);
                    expectedUnion.set(j);
                }
                fill = !fill;
            }
            minIntersection = 50L;
            k = 250000;
            while ((long)k < 250000L + minIntersection) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
                ++k;
            }
            RangeBitmapBenchmarkTest.concise[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            RangeBitmapBenchmarkTest.offheapConcise[i] = RangeBitmapBenchmarkTest.makeOffheapConcise(concise[i]);
            RangeBitmapBenchmarkTest.roaring[i] = r;
            RangeBitmapBenchmarkTest.immutableRoaring[i] = RangeBitmapBenchmarkTest.makeImmutableRoaring(r);
            RangeBitmapBenchmarkTest.offheapRoaring[i] = RangeBitmapBenchmarkTest.makeOffheapRoaring(r);
            RangeBitmapBenchmarkTest.genericConcise[i] = new WrappedImmutableConciseBitmap(offheapConcise[i]);
            RangeBitmapBenchmarkTest.genericRoaring[i] = new WrappedImmutableRoaringBitmap(offheapRoaring[i]);
        }
        unionCount = expectedUnion.cardinality();
        RangeBitmapBenchmarkTest.printSizeStats(0.001, "Random Alternating Bitmap");
    }
}

