/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial.split;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.RoaringBitmapFactory;
import com.metamx.collections.spatial.Node;
import com.metamx.collections.spatial.Point;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class LinearGutmanSplitStrategyTest {
    @Test
    public void testPickSeeds() throws Exception {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        LinearGutmanSplitStrategy strategy = new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf);
        Node node = new Node(new float[2], new float[2], true, (BitmapFactory)bf);
        node.addChild((Node)new Point(new float[]{3.0f, 7.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{1.0f, 6.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{9.0f, 8.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{2.0f, 5.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{4.0f, 4.0f}, 1, (BitmapFactory)bf));
        node.enclose();
        Node[] groups = strategy.split(node);
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[0]), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[1]), (Object)Float.valueOf(4.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[0]), (Object)Float.valueOf(9.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[1]), (Object)Float.valueOf(8.0f));
    }

    @Test
    public void testPickSeedsRoaring() throws Exception {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        LinearGutmanSplitStrategy strategy = new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf);
        Node node = new Node(new float[2], new float[2], true, (BitmapFactory)bf);
        node.addChild((Node)new Point(new float[]{3.0f, 7.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{1.0f, 6.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{9.0f, 8.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{2.0f, 5.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{4.0f, 4.0f}, 1, (BitmapFactory)bf));
        node.enclose();
        Node[] groups = strategy.split(node);
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[0]), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[1]), (Object)Float.valueOf(4.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[0]), (Object)Float.valueOf(9.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[1]), (Object)Float.valueOf(8.0f));
    }

    @Test
    public void testNumChildrenSize() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            tree.insert(new float[]{rand.nextFloat(), rand.nextFloat()}, i);
        }
        Assert.assertTrue((this.getNumPoints(tree.getRoot()) >= tree.getSize() ? 1 : 0) != 0);
    }

    @Test
    public void testNumChildrenSizeRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            tree.insert(new float[]{rand.nextFloat(), rand.nextFloat()}, i);
        }
        Assert.assertTrue((this.getNumPoints(tree.getRoot()) >= tree.getSize() ? 1 : 0) != 0);
    }

    private int getNumPoints(Node node) {
        int total = 0;
        if (node.isLeaf()) {
            total += node.getChildren().size();
        } else {
            for (Node child : node.getChildren()) {
                total += this.getNumPoints(child);
            }
        }
        return total;
    }
}

