/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.metamx.collections.spatial.ImmutablePoint;
import com.metamx.collections.spatial.search.RectangularBound;
import java.nio.ByteBuffer;

public class RadiusBound
extends RectangularBound {
    private static final byte CACHE_TYPE_ID = 1;
    private final float[] coords;
    private final float radius;

    private static float[] getMinCoords(float[] coords, float radius) {
        float[] retVal = new float[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            retVal[i] = coords[i] - radius;
        }
        return retVal;
    }

    private static float[] getMaxCoords(float[] coords, float radius) {
        float[] retVal = new float[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            retVal[i] = coords[i] + radius;
        }
        return retVal;
    }

    @JsonCreator
    public RadiusBound(@JsonProperty(value="coords") float[] coords, @JsonProperty(value="radius") float radius, @JsonProperty(value="limit") int limit) {
        super(RadiusBound.getMinCoords(coords, radius), RadiusBound.getMaxCoords(coords, radius), limit);
        this.coords = coords;
        this.radius = radius;
    }

    public RadiusBound(float[] coords, float radius) {
        this(coords, radius, 0);
    }

    @JsonProperty
    public float[] getCoords() {
        return this.coords;
    }

    @JsonProperty
    public float getRadius() {
        return this.radius;
    }

    @Override
    public boolean contains(float[] otherCoords) {
        double total = 0.0;
        for (int i = 0; i < this.coords.length; ++i) {
            total += Math.pow(otherCoords[i] - this.coords[i], 2.0);
        }
        return total <= Math.pow(this.radius, 2.0);
    }

    @Override
    public Iterable<ImmutablePoint> filter(Iterable<ImmutablePoint> points) {
        return Iterables.filter(points, (Predicate)new Predicate<ImmutablePoint>(){

            public boolean apply(ImmutablePoint point) {
                return RadiusBound.this.contains(point.getCoords());
            }
        });
    }

    @Override
    public byte[] getCacheKey() {
        ByteBuffer minCoordsBuffer = ByteBuffer.allocate(this.coords.length * 4);
        minCoordsBuffer.asFloatBuffer().put(this.coords);
        byte[] minCoordsCacheKey = minCoordsBuffer.array();
        ByteBuffer cacheKey = ByteBuffer.allocate(1 + minCoordsCacheKey.length + 4 + 4).put(minCoordsCacheKey).putFloat(this.radius).putInt(this.getLimit()).put((byte)1);
        return cacheKey.array();
    }
}

