/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.emitter.core.BatchingStrategy;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpEmitterConfig {
    private static final int DEFAULT_MAX_BATCH_SIZE = 0x500000;
    private static final long DEFAULT_MAX_BUFFER_SIZE = 0xFA00000L;
    private static final long DEFAULT_FLUSH_TIME_OUT = Long.MAX_VALUE;
    private static final String DEFAULT_BASIC_AUTHENTICATION = null;
    private static final BatchingStrategy DEFAULT_BATCHING_STRATEGY = BatchingStrategy.ARRAY;
    @Min(value=1L)
    @JsonProperty
    private long flushMillis = 60000L;
    @Min(value=0L)
    @JsonProperty
    private int flushCount = 500;
    @Min(value=0L)
    @JsonProperty
    private long flushTimeOut = Long.MAX_VALUE;
    @NotNull
    @JsonProperty
    private String recipientBaseUrl = null;
    @JsonProperty
    private String basicAuthentication = DEFAULT_BASIC_AUTHENTICATION;
    @JsonProperty
    private BatchingStrategy batchingStrategy = DEFAULT_BATCHING_STRATEGY;
    @Min(value=0L)
    @JsonProperty
    private int maxBatchSize = 0x500000;
    @Min(value=0L)
    @JsonProperty
    private long maxBufferSize = 0xFA00000L;

    public HttpEmitterConfig() {
    }

    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, DEFAULT_BASIC_AUTHENTICATION, DEFAULT_BATCHING_STRATEGY, 0x500000, 0xFA00000L);
    }

    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl, int maxBatchSize, long maxBufferSize) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, DEFAULT_BASIC_AUTHENTICATION, DEFAULT_BATCHING_STRATEGY, maxBatchSize, maxBufferSize);
    }

    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl, String basicAuthentication, BatchingStrategy batchingStrategy, int maxBatchSize, long maxBufferSize) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, basicAuthentication, batchingStrategy, maxBatchSize, maxBufferSize);
    }

    public HttpEmitterConfig(long flushMillis, int flushCount, long flushTimeOut, String recipientBaseUrl, String basicAuthentication, BatchingStrategy batchingStrategy, int maxBatchSize, long maxBufferSize) {
        this.flushMillis = flushMillis;
        this.flushCount = flushCount;
        this.flushTimeOut = flushTimeOut;
        this.recipientBaseUrl = recipientBaseUrl;
        this.basicAuthentication = basicAuthentication;
        this.batchingStrategy = batchingStrategy;
        this.maxBatchSize = maxBatchSize;
        this.maxBufferSize = maxBufferSize;
    }

    public long getFlushMillis() {
        return this.flushMillis;
    }

    public int getFlushCount() {
        return this.flushCount;
    }

    public long getFlushTimeOut() {
        return this.flushTimeOut;
    }

    public String getRecipientBaseUrl() {
        return this.recipientBaseUrl;
    }

    public String getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public long getMaxBufferSize() {
        return this.maxBufferSize;
    }
}

