/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.service;

import com.google.common.collect.Maps;
import com.metamx.emitter.service.AlertEvent;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceEventBuilder;
import java.util.Map;

public class AlertBuilder {
    protected final Map<String, Object> dataMap = Maps.newLinkedHashMap();
    protected final String description;
    protected final ServiceEmitter emitter;
    protected AlertEvent.Severity severity = AlertEvent.Severity.DEFAULT;

    public static AlertBuilder create(String descriptionFormat, Object ... objects) {
        return AlertBuilder.createEmittable(null, descriptionFormat, objects);
    }

    public static AlertBuilder createEmittable(ServiceEmitter emitter, String descriptionFormat, Object ... objects) {
        return new AlertBuilder(String.format(descriptionFormat, objects), emitter);
    }

    protected AlertBuilder(String description, ServiceEmitter emitter) {
        this.description = description;
        this.emitter = emitter;
    }

    public AlertBuilder addData(String identifier, Object value) {
        this.dataMap.put(identifier, value);
        return this;
    }

    public AlertBuilder severity(AlertEvent.Severity severity) {
        this.severity = severity;
        return this;
    }

    public ServiceEventBuilder<AlertEvent> build() {
        return new ServiceEventBuilder<AlertEvent>(){

            @Override
            public AlertEvent build(String service, String host) {
                return new AlertEvent(service, host, AlertBuilder.this.severity, AlertBuilder.this.description, AlertBuilder.this.dataMap);
            }
        };
    }

    public void emit() {
        if (this.emitter == null) {
            throw new UnsupportedOperationException("Emitter is null, cannot emit.");
        }
        this.emitter.emit(this.build());
    }
}

