/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.google.common.base.Preconditions;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import java.io.IOException;
import java.util.List;

public class ComposingEmitter
implements Emitter {
    private static Logger log = new Logger(ComposingEmitter.class);
    private final List<Emitter> emitters;

    public ComposingEmitter(List<Emitter> emitters) {
        this.emitters = (List)Preconditions.checkNotNull(emitters, (Object)"null emitters");
    }

    @Override
    @LifecycleStart
    public void start() {
        log.info("Starting Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            log.info("Starting emitter %s.", new Object[]{e.getClass().getName()});
            e.start();
        }
    }

    @Override
    public void emit(Event event) {
        for (Emitter e : this.emitters) {
            e.emit(event);
        }
    }

    @Override
    public void flush() throws IOException {
        boolean fail = false;
        log.info("Flushing Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            try {
                log.info("Flushing emitter %s.", new Object[]{e.getClass().getName()});
                e.flush();
            }
            catch (IOException ex) {
                log.error((Throwable)ex, "Failed to flush emitter [%s]", new Object[]{e.getClass().getName()});
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to flush one or more emitters");
        }
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        boolean fail = false;
        log.info("Closing Composing Emitter.", new Object[0]);
        for (Emitter e : this.emitters) {
            try {
                log.info("Closing emitter %s.", new Object[]{e.getClass().getName()});
                e.close();
            }
            catch (IOException ex) {
                log.error((Throwable)ex, "Failed to close emitter [%s]", new Object[]{e.getClass().getName()});
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to close one or more emitters");
        }
    }

    public String toString() {
        return "ComposingEmitter{emitters=" + this.emitters + '}';
    }
}

