/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.emitter.core.BaseHttpEmittingConfig;
import com.metamx.emitter.core.BatchingStrategy;
import com.metamx.emitter.core.ContentEncoding;
import javax.validation.constraints.NotNull;

public class HttpEmitterConfig
extends BaseHttpEmittingConfig {
    @NotNull
    @JsonProperty
    String recipientBaseUrl = null;

    public HttpEmitterConfig() {
    }

    public HttpEmitterConfig(BaseHttpEmittingConfig base, String recipientBaseUrl) {
        this.flushMillis = base.flushMillis;
        this.flushCount = base.flushCount;
        this.flushTimeOut = base.flushTimeOut;
        this.recipientBaseUrl = recipientBaseUrl;
        this.basicAuthentication = base.basicAuthentication;
        this.batchingStrategy = base.batchingStrategy;
        this.maxBatchSize = base.maxBatchSize;
        this.maxBufferSize = base.maxBufferSize;
        this.contentEncoding = base.contentEncoding;
    }

    public String getRecipientBaseUrl() {
        return this.recipientBaseUrl;
    }

    @Override
    public String toString() {
        return "HttpEmitterConfig{" + this.toStringBase() + ", recipientBaseUrl='" + this.recipientBaseUrl + '\'' + '}';
    }

    public static class Builder
    extends HttpEmitterConfig {
        public Builder(String recipientBaseUrl) {
            this.recipientBaseUrl = recipientBaseUrl;
        }

        public Builder setFlushMillis(long flushMillis) {
            this.flushMillis = flushMillis;
            return this;
        }

        public Builder setFlushCount(int flushCount) {
            this.flushCount = flushCount;
            return this;
        }

        public Builder setFlushTimeOut(long flushTimeOut) {
            this.flushTimeOut = flushTimeOut;
            return this;
        }

        public Builder setBasicAuthentication(String basicAuthentication) {
            this.basicAuthentication = basicAuthentication;
            return this;
        }

        public Builder setBatchingStrategy(BatchingStrategy batchingStrategy) {
            this.batchingStrategy = batchingStrategy;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder setContentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public HttpEmitterConfig build() {
            return new HttpEmitterConfig(this, this.recipientBaseUrl);
        }
    }
}

