/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.core.LoggingEmitterConfig;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class LoggingEmitter
implements Emitter {
    private final Logger log;
    private final Level level;
    private final ObjectMapper jsonMapper;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public LoggingEmitter(LoggingEmitterConfig config, ObjectMapper jsonMapper) {
        this(new Logger(config.getLoggerClass()), Level.toLevel(config.getLogLevel()), jsonMapper);
    }

    public LoggingEmitter(Logger log, Level level, ObjectMapper jsonMapper) {
        this.log = log;
        this.level = level;
        this.jsonMapper = jsonMapper;
    }

    @Override
    @LifecycleStart
    public void start() {
        boolean alreadyStarted = this.started.getAndSet(true);
        if (!alreadyStarted) {
            String message = "Start: started [%s]";
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Start: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Start: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Start: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case WARN: {
                    this.log.warn("Start: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case ERROR: {
                    this.log.error("Start: started [%s]", new Object[]{this.started.get()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Event event) {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                throw new RejectedExecutionException("Service not started.");
            }
        }
        try {
            String message = "Event [%s]";
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Event [%s]", new Object[]{this.jsonMapper.writeValueAsString((Object)event)});
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Event [%s]", new Object[]{this.jsonMapper.writeValueAsString((Object)event)});
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Event [%s]", new Object[]{this.jsonMapper.writeValueAsString((Object)event)});
                    break;
                }
                case WARN: {
                    this.log.warn("Event [%s]", new Object[]{this.jsonMapper.writeValueAsString((Object)event)});
                    break;
                }
                case ERROR: {
                    this.log.error("Event [%s]", new Object[]{this.jsonMapper.writeValueAsString((Object)event)});
                }
            }
        }
        catch (Exception e) {
            this.log.warn((Throwable)e, "Failed to generate json", new Object[0]);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        boolean wasStarted = this.started.getAndSet(false);
        if (wasStarted) {
            String message = "Close: started [%s]";
            switch (this.level) {
                case TRACE: {
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Close: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case DEBUG: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Close: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case INFO: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("Close: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case WARN: {
                    this.log.warn("Close: started [%s]", new Object[]{this.started.get()});
                    break;
                }
                case ERROR: {
                    this.log.error("Close: started [%s]", new Object[]{this.started.get()});
                }
            }
        }
    }

    public String toString() {
        return "LoggingEmitter{log=" + this.log + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public static Level toLevel(String name) {
            return Level.valueOf(name.toUpperCase());
        }
    }
}

