/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers;

import it.uniroma3.mat.extendedset.AbstractExtendedSet;
import it.uniroma3.mat.extendedset.ExtendedSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IntegerSet
extends AbstractExtendedSet<Integer> {
    private final IntSet items;

    public IntegerSet(IntSet items) {
        this.items = items;
    }

    public IntSet intSet() {
        return this.items;
    }

    private IntSet toIntSet(Collection<?> c) {
        if (c == null) {
            return null;
        }
        if (c instanceof IntegerSet) {
            return ((IntegerSet)c).items;
        }
        IntSet res = this.items.empty();
        ArrayList<Integer> sorted = new ArrayList<Integer>(c.size());
        for (Object obj : c) {
            try {
                sorted.add((Integer)obj);
            }
            catch (ClassCastException classCastException) {}
        }
        Collections.sort(sorted);
        for (Integer n : sorted) {
            res.add(n);
        }
        return res;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        return this.items.addAll(this.toIntSet(c));
    }

    @Override
    public double bitmapCompressionRatio() {
        return this.items.bitmapCompressionRatio();
    }

    @Override
    public void clear(Integer from, Integer to) {
        this.items.clear(from, to);
    }

    @Override
    public IntegerSet clone() {
        return new IntegerSet(this.items.clone());
    }

    @Override
    public double collectionCompressionRatio() {
        return this.items.collectionCompressionRatio();
    }

    @Override
    public int compareTo(ExtendedSet<Integer> o) {
        return this.items.compareTo(this.toIntSet(o));
    }

    public IntegerSet complemented() {
        return new IntegerSet(this.items.complemented());
    }

    @Override
    public int complementSize() {
        return this.items.complementSize();
    }

    @Override
    public boolean containsAny(Collection<? extends Integer> other) {
        return this.items.containsAny(this.toIntSet(other));
    }

    @Override
    public boolean containsAtLeast(Collection<? extends Integer> other, int minElements) {
        return this.items.containsAtLeast(this.toIntSet(other), minElements);
    }

    public IntegerSet convert(Collection<?> c) {
        return new IntegerSet(this.toIntSet(c));
    }

    public IntegerSet convert(Object ... e) {
        return this.convert(Arrays.asList(e));
    }

    @Override
    public String debugInfo() {
        return this.getClass().getSimpleName() + "\n" + this.items.debugInfo();
    }

    @Override
    public ExtendedSet.ExtendedIterator<Integer> descendingIterator() {
        return new ExtendedSet.ExtendedIterator<Integer>(){
            final IntSet.IntIterator itr;
            {
                this.itr = IntegerSet.this.items.descendingIterator();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public Integer next() {
                return this.itr.next();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void skipAllBefore(Integer element) {
                this.itr.skipAllBefore(element);
            }
        };
    }

    public IntegerSet difference(Collection<? extends Integer> other) {
        return new IntegerSet(this.items.difference(this.toIntSet(other)));
    }

    @Override
    public int differenceSize(Collection<? extends Integer> other) {
        return this.items.differenceSize(this.toIntSet(other));
    }

    public IntegerSet empty() {
        return new IntegerSet(this.items.empty());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerSet)) {
            return false;
        }
        return this.items.equals(((IntegerSet)o).items);
    }

    @Override
    public void fill(Integer from, Integer to) {
        this.items.fill(from, to);
    }

    @Override
    public Integer first() {
        return this.items.first();
    }

    @Override
    public void flip(Integer e) {
        this.items.flip(e);
    }

    @Override
    public Integer get(int i) {
        return this.items.get(i);
    }

    @Override
    public int indexOf(Integer e) {
        return this.items.indexOf(e);
    }

    public IntegerSet intersection(Collection<? extends Integer> other) {
        return new IntegerSet(this.items.intersection(this.toIntSet(other)));
    }

    @Override
    public int intersectionSize(Collection<? extends Integer> other) {
        return this.items.intersectionSize(this.toIntSet(other));
    }

    @Override
    public ExtendedSet.ExtendedIterator<Integer> iterator() {
        return new ExtendedSet.ExtendedIterator<Integer>(){
            final IntSet.IntIterator itr;
            {
                this.itr = IntegerSet.this.items.iterator();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public Integer next() {
                return this.itr.next();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public void skipAllBefore(Integer element) {
                this.itr.skipAllBefore(element);
            }
        };
    }

    @Override
    public Integer last() {
        return this.items.last();
    }

    @Override
    public List<? extends IntegerSet> powerSet() {
        return this.powerSet(1, Integer.MAX_VALUE);
    }

    @Override
    public List<? extends IntegerSet> powerSet(int min, int max) {
        List<? extends IntSet> ps = this.items.powerSet(min, max);
        ArrayList<IntegerSet> res = new ArrayList<IntegerSet>(ps.size());
        for (IntSet intSet : ps) {
            res.add(new IntegerSet(intSet));
        }
        return res;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(this.toIntSet(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(this.toIntSet(c));
    }

    public IntegerSet symmetricDifference(Collection<? extends Integer> other) {
        return new IntegerSet(this.items.symmetricDifference(this.toIntSet(other)));
    }

    @Override
    public int symmetricDifferenceSize(Collection<? extends Integer> other) {
        return this.items.symmetricDifferenceSize(this.toIntSet(other));
    }

    public IntegerSet union(Collection<? extends Integer> other) {
        return new IntegerSet(this.items.union(this.toIntSet(other)));
    }

    @Override
    public int unionSize(Collection<? extends Integer> other) {
        return this.items.unionSize(this.toIntSet(other));
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public void complement() {
        this.items.complement();
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public boolean add(Integer e) {
        return this.items.add(e);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.items.contains((Integer)o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(this.toIntSet(c));
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Integer && this.items.remove((Integer)o);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public String toString() {
        return this.items.toString();
    }

    @Override
    public double jaccardSimilarity(ExtendedSet<Integer> other) {
        return this.items.jaccardSimilarity(this.toIntSet(other));
    }

    @Override
    public double weightedJaccardSimilarity(ExtendedSet<Integer> other) {
        return this.items.weightedJaccardSimilarity(this.toIntSet(other));
    }
}

