/*
 * Copyright 2011 Metamarkets Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.metamx.http.client.response;

/**
 */
public class ClientResponse<T>
{
  private final boolean finished;
  private final T obj;

  public static <T> ClientResponse<T> finished(T obj)
  {
    return new ClientResponse<T>(true, obj);
  }

  public static <T> ClientResponse<T> unfinished(T obj)
  {
    return new ClientResponse<T>(false, obj);
  }

  protected ClientResponse(
    boolean finished,
    T obj
  )
  {
    this.finished = finished;
    this.obj = obj;
  }

  public boolean isFinished()
  {
    return finished;
  }

  public T getObj()
  {
    return obj;
  }
}
