/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.IllegalFormatException;

public class StringUtils {
    @Deprecated
    public static final Charset UTF8_CHARSET = Charsets.UTF_8;
    public static final String UTF8_STRING = Charsets.UTF_8.toString();

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String safeFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public static String replaceChar(String s, char c, String replacement) {
        int pos = s.indexOf(c);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - 1 + replacement.length());
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            sb.append(replacement);
            prevPos = pos + 1;
        } while ((pos = s.indexOf(c, pos + 1)) > 0);
        sb.append(s, prevPos, s.length());
        return sb.toString();
    }
}

