/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.google.common.base.Preconditions;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComposingEmitter
implements Emitter {
    private static Logger log = new Logger(ComposingEmitter.class);
    private final Map<String, Emitter> emitters;

    public ComposingEmitter(Map<String, Emitter> emitters) {
        this.emitters = (Map)Preconditions.checkNotNull(emitters, (Object)"null emitters");
    }

    public ComposingEmitter(List<Emitter> emitters) {
        this.emitters = emitters.stream().collect(Collectors.toMap(e -> e.getClass().getName() + "@" + Integer.toHexString(e.hashCode()), e -> e));
    }

    @Override
    @LifecycleStart
    public void start() {
        log.info("Starting Composing Emitter.", new Object[0]);
        for (Map.Entry<String, Emitter> e : this.emitters.entrySet()) {
            log.info("Starting emitter [%s].", e.getKey());
            e.getValue().start();
        }
    }

    @Override
    public void emit(Event event) {
        for (Emitter e : this.emitters.values()) {
            e.emit(event);
        }
    }

    @Override
    public void flush() throws IOException {
        boolean fail = false;
        log.info("Flushing Composing Emitter.", new Object[0]);
        for (Map.Entry<String, Emitter> e : this.emitters.entrySet()) {
            try {
                log.info("Flushing emitter [%s].", e.getKey());
                e.getValue().flush();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to flush emitter [%s]", e.getKey());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to flush one or more emitters");
        }
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        boolean fail = false;
        log.info("Closing Composing Emitter.", new Object[0]);
        for (Map.Entry<String, Emitter> e : this.emitters.entrySet()) {
            try {
                log.info("Closing emitter [%s].", e.getKey());
                e.getValue().close();
            }
            catch (IOException ex) {
                log.error(ex, "Failed to close emitter [%s]", e.getKey());
                fail = true;
            }
        }
        if (fail) {
            throw new IOException("failed to close one or more emitters");
        }
    }

    public String toString() {
        return "ComposingEmitter{emitters=" + this.emitters + '}';
    }
}

