/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.metamx.emitter.core.Event;
import com.metamx.emitter.core.UriExtractor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParametrizedUriExtractor
implements UriExtractor {
    private String uriPattern;
    private Set<String> params;

    public ParametrizedUriExtractor(String uriPattern) {
        this.uriPattern = uriPattern;
        Matcher keyMatcher = Pattern.compile("\\{([^\\}]+)\\}").matcher(uriPattern);
        this.params = new HashSet<String>();
        while (keyMatcher.find()) {
            this.params.add(keyMatcher.group(1));
        }
    }

    public Set<String> getParams() {
        return this.params;
    }

    @Override
    public URI apply(Event event) throws URISyntaxException {
        Map<String, Object> eventMap = event.toMap();
        String processedUri = this.uriPattern;
        for (String key : this.params) {
            Object paramValue = eventMap.get(key);
            if (paramValue == null) {
                throw new IllegalArgumentException(String.format("ParametrizedUriExtractor with pattern %s requires %s to be set in event, but found %s", this.uriPattern, key, eventMap));
            }
            processedUri = processedUri.replace(String.format("{%s}", key), paramValue.toString());
        }
        return new URI(processedUri);
    }

    public String toString() {
        return "ParametrizedUriExtractor{uriPattern='" + this.uriPattern + '\'' + ", params=" + this.params + '}';
    }
}

