/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core.filter;

import com.metamx.emitter.core.filter.BWListEventFilter;
import com.metamx.emitter.core.filter.BWListEventFilterConfig;
import com.metamx.emitter.core.filter.EmptyBWListEventFilter;
import com.metamx.emitter.core.filter.FeedBWListEventFilter;
import com.metamx.emitter.core.filter.MultiBWListEventFilter;
import java.util.HashSet;

public class BWListEventFilterFactory {
    private static final String FEED_FIELD_NAME = "feed";

    public static BWListEventFilter makeEventFilter(BWListEventFilterConfig config) {
        HashSet<String> commonKeys = new HashSet<String>(config.getWhiteList().keySet());
        commonKeys.addAll(config.getBlackList().keySet());
        if (commonKeys.size() == 0) {
            return new EmptyBWListEventFilter();
        }
        if (commonKeys.size() == 1 && commonKeys.contains(FEED_FIELD_NAME)) {
            return new FeedBWListEventFilter(config.getWhiteList().get(FEED_FIELD_NAME), config.getBlackList().get(FEED_FIELD_NAME));
        }
        return new MultiBWListEventFilter(config.getWhiteList(), config.getBlackList());
    }
}

