/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core.filter;

import com.metamx.emitter.core.Event;
import com.metamx.emitter.core.filter.BWListEventFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiBWListEventFilter
implements BWListEventFilter {
    private final Map<String, Set<String>> fieldToValueWhiteSet;
    private final Map<String, Set<String>> fieldToValueBlackSet;

    public MultiBWListEventFilter(Map<String, List<String>> fieldToValueWhiteList, Map<String, List<String>> fieldToValueBlackList) {
        this.fieldToValueWhiteSet = fieldToValueWhiteList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue())));
        this.fieldToValueBlackSet = fieldToValueBlackList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue())));
    }

    @Override
    public boolean isNotWhiteListed(Event event) {
        Map<String, Object> eventMap = event.toMap();
        return this.fieldToValueWhiteSet.entrySet().stream().anyMatch(e -> eventMap.containsKey(e.getKey()) && !((Set)e.getValue()).contains(eventMap.get(e.getKey())));
    }

    @Override
    public boolean isBlackListed(Event event) {
        Map<String, Object> eventMap = event.toMap();
        return this.fieldToValueBlackSet.entrySet().stream().anyMatch(e -> eventMap.containsKey(e.getKey()) && ((Set)e.getValue()).contains(eventMap.get(e.getKey())));
    }
}

