/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics.cgroups;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.metamx.common.RE;
import com.metamx.metrics.CgroupUtil;
import com.metamx.metrics.cgroups.CgroupDiscoverer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ProcCgroupDiscoverer
implements CgroupDiscoverer {
    private static final String CGROUP_TYPE = "cgroup";
    private final File procDir;

    public ProcCgroupDiscoverer(Path procDir) {
        this.procDir = ((Path)Preconditions.checkNotNull((Object)procDir, (Object)"procDir")).toFile();
        Preconditions.checkArgument((boolean)this.procDir.isDirectory(), (String)"Not a directory: [%s]", (Object[])new Object[]{procDir});
    }

    @Override
    public Path discover(String cgroup) {
        Preconditions.checkNotNull((Object)cgroup, (Object)"cgroup required");
        File procMounts = new File(this.procDir, "mounts");
        File pidCgroups = new File(this.procDir, CGROUP_TYPE);
        PidCgroupEntry pidCgroupsEntry = this.getCgroupEntry(pidCgroups, cgroup);
        ProcMountsEntry procMountsEntry = this.getMountEntry(procMounts, cgroup);
        File cgroupDir = new File(procMountsEntry.path.toString(), pidCgroupsEntry.path.toString());
        if (cgroupDir.exists() && cgroupDir.isDirectory()) {
            return cgroupDir.toPath();
        }
        throw new RE("Invalid cgroup directory [%s]", cgroupDir);
    }

    private PidCgroupEntry getCgroupEntry(File procCgroup, String cgroup) {
        List lines;
        try {
            lines = Files.readLines((File)procCgroup, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            PidCgroupEntry entry = PidCgroupEntry.parse(line);
            if (!entry.controllers.contains(cgroup)) continue;
            return entry;
        }
        throw new RE("Hierarchy for [%s] not found", cgroup);
    }

    private ProcMountsEntry getMountEntry(File procMounts, String cgroup) {
        List lines;
        try {
            lines = Files.readLines((File)procMounts, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            ProcMountsEntry entry = ProcMountsEntry.parse(line);
            if (!CGROUP_TYPE.equals(entry.type) || !entry.options.contains(cgroup)) continue;
            return entry;
        }
        throw new RE("Cgroup [%s] not found", cgroup);
    }

    static class PidCgroupEntry {
        final int heirarchyId;
        final Set<String> controllers;
        final Path path;

        static PidCgroupEntry parse(String entry) {
            String[] parts = entry.split(Pattern.quote(":"), 3);
            if (parts.length != 3) {
                throw new RE("Bad entry [%s]", entry);
            }
            int heirarchyId = Integer.parseInt(parts[0]);
            HashSet<String> controllers = new HashSet<String>(Arrays.asList(parts[1].split(Pattern.quote(","))));
            Path path = Paths.get(parts[2], new String[0]);
            return new PidCgroupEntry(heirarchyId, controllers, path);
        }

        private PidCgroupEntry(int heirarchyId, Set<String> controllers, Path path) {
            this.heirarchyId = heirarchyId;
            this.controllers = controllers;
            this.path = path;
        }
    }

    static class ProcMountsEntry {
        final String dev;
        final Path path;
        final String type;
        final Set<String> options;

        static ProcMountsEntry parse(String entry) {
            String[] splits = entry.split(CgroupUtil.SPACE_MATCH, 6);
            Preconditions.checkArgument((splits.length == 6 ? 1 : 0) != 0, (String)"Invalid entry: [%s]", (Object[])new Object[]{entry});
            return new ProcMountsEntry(splits[0], Paths.get(splits[1], new String[0]), splits[2], (Collection<String>)ImmutableSet.copyOf((Object[])splits[3].split(CgroupUtil.COMMA_MATCH)));
        }

        ProcMountsEntry(String dev, Path path, String type, Collection<String> options) {
            this.dev = dev;
            this.path = path;
            this.type = type;
            this.options = ImmutableSet.copyOf(options);
        }
    }
}

