/*
 * Copyright 2012 Metamarkets Group Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.metamx.common.scala.concurrent

import java.util.concurrent.locks.Lock

object locks {

  class LockOps(l: Lock) {
    def apply[X](x: => X) = {
      l.lock
      try x finally {
        l.unlock
      }
    }
  }

  implicit def LockOps(l: Lock): LockOps = new LockOps(l)

}
