/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen;

import com.metaweb.lessen.ParserBase;
import com.metaweb.lessen.ResourceFinder;
import com.metaweb.lessen.Scope;
import com.metaweb.lessen.expr.Evaluable;
import com.metaweb.lessen.expr.LessMixinFunction;
import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LessFunctionDefinitionParser
extends ParserBase
implements Tokenizer {
    protected Token _identifierToken;
    protected final List<String> _argumentName = new ArrayList<String>();
    protected final List<Token> _argumentDefaults = new ArrayList<Token>();
    protected final List<Object> _stuff = new ArrayList<Object>();

    public LessFunctionDefinitionParser(BufferedTokenizer tokenizer, ResourceFinder resourceFinder, Scope scope) {
        super(tokenizer, resourceFinder, scope, false);
        this.parse();
    }

    public Token getToken() {
        return null;
    }

    public void next() {
    }

    public Token getIdentifierToken() {
        return this._identifierToken;
    }

    public String getIdentifier() {
        return this._identifierToken.type == Token.Type.Identifier ? this._identifierToken.text : this._identifierToken.text.substring(0, this._identifierToken.text.length() - 1);
    }

    public LessMixinFunction getFunction() {
        return new LessMixinFunction(){

            @Override
            public List<Token> invoke(List<Token> arguments, Scope scope) {
                Scope scope2 = new Scope(scope);
                for (int i = 0; i < LessFunctionDefinitionParser.this._argumentName.size(); ++i) {
                    String name = LessFunctionDefinitionParser.this._argumentName.get(i);
                    Token value = arguments != null && i < arguments.size() ? arguments.get(i) : LessFunctionDefinitionParser.this._argumentDefaults.get(i);
                    scope2.put(name, value);
                }
                LinkedList<Token> results = new LinkedList<Token>();
                for (Object o : LessFunctionDefinitionParser.this._stuff) {
                    if (o instanceof Token) {
                        results.add((Token)o);
                        continue;
                    }
                    Token t = ((Evaluable)o).eval(scope2);
                    if (t == null) continue;
                    results.add(t);
                }
                return results;
            }
        };
    }

    protected LessFunctionDefinitionParser createLessFunctionDefinitionParser() {
        return null;
    }

    protected void outputToken(Token t) {
        this._stuff.add(t);
    }

    protected void outputEvaluable(Evaluable e) {
        this._stuff.add(e);
    }

    protected void passInnerBlockTokenThrough(Token t) {
        this._stuff.add(t);
    }

    protected void parse() {
        Token t = this._tokenizer.getToken();
        if (t != null && t.type == Token.Type.Operator && t.text.equals(".")) {
            this._tokenizer.next();
            t = this._tokenizer.getToken();
        }
        if (t != null) {
            if (t.type == Token.Type.Identifier) {
                this._identifierToken = t;
                this._tokenizer.next();
                t = this._tokenizer.getToken();
                this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
                t = this._tokenizer.getToken();
                if (t != null && t.type == Token.Type.Delimiter && t.text.equals("(")) {
                    this._tokenizer.next();
                    t = this._tokenizer.getToken();
                }
            } else if (t.type == Token.Type.Function) {
                this._identifierToken = t;
                this._tokenizer.next();
                t = this._tokenizer.getToken();
            }
        }
        while (true) {
            this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
            t = this._tokenizer.getToken();
            if (t == null) break;
            if (t.type == Token.Type.Delimiter) {
                if (t.text.equals(")")) {
                    this._tokenizer.next();
                    this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
                    t = this._tokenizer.getToken();
                    break;
                }
                if (!t.text.equals("{") && !t.text.equals("}")) continue;
                break;
            }
            if (t.type == Token.Type.AtIdentifier) {
                String name = t.text;
                this._tokenizer.next();
                this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
                t = this._tokenizer.getToken();
                if (t != null && t.type == Token.Type.Delimiter && t.text.equals(":")) {
                    this._tokenizer.next();
                    this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
                    t = this._tokenizer.getToken();
                }
                if (t == null) break;
                if (t.type == Token.Type.Delimiter) {
                    this._argumentName.add(name);
                    this._argumentDefaults.add(null);
                } else {
                    this._argumentName.add(name);
                    this._argumentDefaults.add(t);
                    this._tokenizer.next();
                    this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
                    t = this._tokenizer.getToken();
                }
                if (t == null || t.type != Token.Type.Delimiter || !t.text.equals(",")) continue;
                this._tokenizer.next();
                continue;
            }
            this._tokenizer.next();
        }
        if (t != null && t.type == Token.Type.Delimiter && t.text.equals("{")) {
            this._tokenizer.next();
        }
        while ((t = this._tokenizer.getToken()) != null) {
            if (t.type == Token.Type.Delimiter && t.text.equals("}")) {
                this._tokenizer.next();
                break;
            }
            if (t.type == Token.Type.Whitespace || t.type == Token.Type.Comment) {
                this._tokenizer.next();
                this._stuff.add(t);
                continue;
            }
            Object o = this.parseExpression(true);
            if (o == null) continue;
            this._stuff.add(o);
        }
    }
}

