/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.marshal;

import com.mfizz.ruby.marshal.Marshaller;
import com.mfizz.ruby.marshal.Unmarshaller;
import com.mfizz.ruby.types.RubyType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Marshal {
    public static byte[] dump(RubyType obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Marshal.dump(baos, obj);
        return baos.toByteArray();
    }

    public static void dump(OutputStream os, RubyType obj) throws IOException {
        Marshaller.writeByte(os, 4);
        Marshaller.writeByte(os, 8);
        Marshaller.marshalRubyType(os, obj);
        os.flush();
    }

    public static RubyType load(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        int majorVersion = Unmarshaller.readUnsignedByte(bais);
        int minorVersion = Unmarshaller.readUnsignedByte(bais);
        if (majorVersion != 4) {
            throw new IOException("Unable to support Ruby Marshal major version: " + majorVersion);
        }
        if (minorVersion != 8) {
            throw new IOException("Unable to support Ruby Marshal minor version: " + minorVersion);
        }
        return Unmarshaller.unmarshalRubyType(bais);
    }
}

