/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.marshal;

import com.mfizz.ruby.types.RubyArray;
import com.mfizz.ruby.types.RubyBignum;
import com.mfizz.ruby.types.RubyBoolean;
import com.mfizz.ruby.types.RubyFixnum;
import com.mfizz.ruby.types.RubyHash;
import com.mfizz.ruby.types.RubyObject;
import com.mfizz.ruby.types.RubyString;
import com.mfizz.ruby.types.RubySymbol;
import com.mfizz.ruby.types.RubyType;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;

public class Marshaller {
    public static void marshalRubyType(OutputStream os, RubyType value) throws IOException {
        if (value == null) {
            Marshaller.marshalNil(os);
        } else if (value instanceof RubyBoolean) {
            Marshaller.marshalRubyBoolean(os, (RubyBoolean)value);
        } else if (value instanceof RubyBignum) {
            Marshaller.marshalRubyBignum(os, (RubyBignum)value);
        } else if (value instanceof RubyString) {
            Marshaller.marshalRubyString(os, (RubyString)value);
        } else if (value instanceof RubySymbol) {
            Marshaller.marshalRubySymbol(os, (RubySymbol)value);
        } else if (value instanceof RubyObject) {
            Marshaller.marshalRubyObject(os, (RubyObject)value);
        } else if (value instanceof RubyHash) {
            Marshaller.marshalRubyHash(os, (RubyHash)value);
        } else if (value instanceof RubyArray) {
            Marshaller.marshalRubyArray(os, (RubyArray)value);
        } else if (value instanceof RubyFixnum) {
            Marshaller.marshalRubyFixnum(os, (RubyFixnum)value);
        } else {
            throw new IOException("Unable or unsupported marshal for type " + value.getClass().getCanonicalName());
        }
    }

    public static void marshalRubyFixnum(OutputStream os, RubyFixnum fixnum) throws IOException {
        Marshaller.writeByte(os, 105);
        Marshaller.writeInt(os, (int)fixnum.getValue());
    }

    public static void marshalNil(OutputStream os) throws IOException {
        Marshaller.writeByte(os, 48);
    }

    public static void marshalRubyBoolean(OutputStream os, RubyBoolean bool) throws IOException {
        if (bool.getValue()) {
            Marshaller.writeByte(os, 84);
        } else {
            Marshaller.writeByte(os, 70);
        }
    }

    public static void marshalRubyBignum(OutputStream os, RubyBignum bignum) throws IOException {
        Marshaller.writeByte(os, 108);
        Marshaller.writeBigInteger(os, bignum.getValue());
    }

    public static void marshalRubyString(OutputStream os, RubyString str) throws IOException {
        Marshaller.writeByte(os, 34);
        Marshaller.writeRubyString(os, str);
    }

    public static void marshalRubyArray(OutputStream os, RubyArray array) throws IOException {
        Marshaller.writeByte(os, 91);
        Marshaller.writeInt(os, array.getArray().size());
        for (RubyType rubyType : array.getArray()) {
            Marshaller.marshalRubyType(os, rubyType);
        }
    }

    public static void marshalRubyHash(OutputStream os, RubyHash hash) throws IOException {
        Marshaller.writeByte(os, 123);
        Marshaller.writeInt(os, hash.getMap().size());
        for (Map.Entry<RubyType, RubyType> entry : hash.getMap().entrySet()) {
            Marshaller.marshalRubyType(os, entry.getKey());
            Marshaller.marshalRubyType(os, entry.getValue());
        }
    }

    public static void marshalRubySymbol(OutputStream os, RubySymbol value) throws IOException {
        Marshaller.writeByte(os, 58);
        Marshaller.writeJavaStringAsUTF8Bytes(os, value.getName());
    }

    public static void marshalRubyObject(OutputStream os, RubyObject value) throws IOException {
        Marshaller.writeByte(os, 111);
        Marshaller.marshalRubySymbol(os, value.getName());
        Marshaller.writeVariables(os, value.getVariables());
    }

    public static void writeVariables(OutputStream os, Map<RubySymbol, RubyType> vars) throws IOException {
        Marshaller.writeInt(os, vars.size());
        Marshaller.writeVariablesShared(os, vars);
    }

    private static void writeVariablesShared(OutputStream os, Map<RubySymbol, RubyType> vars) throws IOException {
        for (Map.Entry<RubySymbol, RubyType> var : vars.entrySet()) {
            Marshaller.marshalRubySymbol(os, var.getKey());
            Marshaller.marshalRubyType(os, var.getValue());
        }
    }

    public static void writeJavaStringAsUTF8Bytes(OutputStream os, String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        Marshaller.writeInt(os, bytes.length);
        os.write(bytes);
    }

    public static void writeRubyString(OutputStream os, RubyString value) throws IOException {
        Marshaller.writeInt(os, value.getBytes().length);
        os.write(value.getBytes());
    }

    public static void writeInt(OutputStream os, int value) throws IOException {
        if (value == 0) {
            os.write(0);
        } else if (0 < value && value < 123) {
            os.write(value + 5);
        } else if (-124 < value && value < 0) {
            os.write(value - 5 & 0xFF);
        } else {
            int i;
            byte[] buf = new byte[4];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(value & 0xFF);
                if ((value >>= 8) == 0 || value == -1) break;
            }
            int len = i + 1;
            os.write(value < 0 ? -len : len);
            os.write(buf, 0, i + 1);
        }
    }

    public static void writeBigInteger(OutputStream os, BigInteger bigint) throws IOException {
        os.write(bigint.signum() >= 0 ? 43 : 45);
        BigInteger absValue = bigint.abs();
        byte[] digits = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits.length % 2 != 0 && digits[0] != 0;
        int shortLength = digits.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        Marshaller.writeInt(os, shortLength);
        for (int i = 1; i <= shortLength * 2 && i <= digits.length; ++i) {
            Marshaller.writeByte(os, digits[digits.length - i]);
        }
        if (oddLengthNonzeroStart) {
            Marshaller.writeByte(os, 0);
        }
    }

    public static void writeByte(OutputStream os, int value) throws IOException {
        os.write(value);
    }
}

