/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.marshal;

import com.mfizz.ruby.types.RubyArray;
import com.mfizz.ruby.types.RubyBignum;
import com.mfizz.ruby.types.RubyBoolean;
import com.mfizz.ruby.types.RubyFixnum;
import com.mfizz.ruby.types.RubyHash;
import com.mfizz.ruby.types.RubyObject;
import com.mfizz.ruby.types.RubyString;
import com.mfizz.ruby.types.RubySymbol;
import com.mfizz.ruby.types.RubyType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(Unmarshaller.class);

    public static RubyType unmarshalRubyType(InputStream is) throws IOException {
        int type = Unmarshaller.readUnsignedByte(is);
        RubyType result = Unmarshaller.unmarshalRubyTypeDirectly(type, is);
        return result;
    }

    public static RubyType unmarshalRubyTypeDirectly(int type, InputStream is) throws IOException {
        switch (type) {
            case 48: {
                return null;
            }
            case 84: {
                return new RubyBoolean(true);
            }
            case 70: {
                return new RubyBoolean(false);
            }
            case 34: {
                return new RubyString(Unmarshaller.readRubyStringAsBytes(is));
            }
            case 105: {
                return new RubyFixnum(Unmarshaller.readRubyInt(is));
            }
            case 58: {
                return new RubySymbol(Unmarshaller.readRubyStringAsUTF8String(is));
            }
            case 91: {
                return Unmarshaller.unmarshalRubyArray(is);
            }
            case 123: {
                return Unmarshaller.unmarshalRubyHash(is);
            }
            case 108: {
                return new RubyBignum(Unmarshaller.readBigInteger(is));
            }
            case 111: {
                return Unmarshaller.unmarshalRubyObject(is);
            }
        }
        throw new UnsupportedOperationException("Unable to handle type value: " + type + " or known as [" + (char)type + "]");
    }

    public static int readUnsignedByte(InputStream is) throws IOException {
        int result = is.read();
        if (result == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return result;
    }

    public static byte readSignedByte(InputStream is) throws IOException {
        int b = Unmarshaller.readUnsignedByte(is);
        if (b > 127) {
            return (byte)(b - 256);
        }
        return (byte)b;
    }

    public static String readRubyStringAsUTF8String(InputStream is) throws IOException {
        byte[] buffer = Unmarshaller.readRubyStringAsBytes(is);
        return new String(buffer, "UTF-8");
    }

    public static byte[] readRubyStringAsBytes(InputStream is) throws IOException {
        int read;
        int length = Unmarshaller.readRubyIntAsJavaInt(is);
        byte[] buffer = new byte[length];
        for (int readLength = 0; readLength < length; readLength += read) {
            read = is.read(buffer, readLength, length - readLength);
            if (read != -1) continue;
            throw new IOException("marshal data too short");
        }
        return buffer;
    }

    public static int readRubyIntAsJavaInt(InputStream is) throws IOException {
        return (int)Unmarshaller.readRubyInt(is);
    }

    public static long readRubyInt(InputStream is) throws IOException {
        long result;
        int c = Unmarshaller.readSignedByte(is);
        if (c == 0) {
            return 0L;
        }
        if (5 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -5) {
            return c + 5;
        }
        if (c > 0) {
            result = 0L;
            for (int i = 0; i < c; ++i) {
                result |= (long)Unmarshaller.readUnsignedByte(is) << 8 * i;
            }
        } else {
            c = -c;
            result = -1L;
            for (int i = 0; i < c; ++i) {
                result &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                result |= (long)Unmarshaller.readUnsignedByte(is) << 8 * i;
            }
        }
        return result;
    }

    public static BigInteger readBigInteger(InputStream is) throws IOException {
        boolean positive = Unmarshaller.readUnsignedByte(is) == 43;
        int shortLength = Unmarshaller.readRubyIntAsJavaInt(is);
        byte[] digits = new byte[shortLength * 2 + 1];
        for (int i = digits.length - 1; i >= 1; --i) {
            digits[i] = Unmarshaller.readSignedByte(is);
        }
        BigInteger value = new BigInteger(digits);
        if (!positive) {
            value = value.negate();
        }
        return value;
    }

    public static RubyArray unmarshalRubyArray(InputStream is) throws IOException {
        int size = Unmarshaller.readRubyIntAsJavaInt(is);
        RubyType[] array = new RubyType[size];
        for (int i = 0; i < size; ++i) {
            array[i] = Unmarshaller.unmarshalRubyType(is);
        }
        return new RubyArray(array);
    }

    public static RubyHash unmarshalRubyHash(InputStream is) throws IOException {
        int size = Unmarshaller.readRubyIntAsJavaInt(is);
        LinkedHashMap<RubyType, RubyType> hash = new LinkedHashMap<RubyType, RubyType>();
        for (int i = 0; i < size; ++i) {
            RubyType key = Unmarshaller.unmarshalRubyType(is);
            RubyType value = Unmarshaller.unmarshalRubyType(is);
            hash.put(key, value);
        }
        return new RubyHash(hash);
    }

    public static RubyObject unmarshalRubyObject(InputStream is) throws IOException {
        RubyType objectName = Unmarshaller.unmarshalRubyType(is);
        if (!(objectName instanceof RubySymbol)) {
            throw new IOException("Expected symbol for object name but was something else intead");
        }
        RubyObject ro = new RubyObject((RubySymbol)objectName);
        Unmarshaller.unmarshalRubyObjectVariables(ro, is);
        return ro;
    }

    public static void unmarshalRubyObjectVariables(RubyObject ro, InputStream is) throws IOException {
        int count;
        int i = count = Unmarshaller.readRubyIntAsJavaInt(is);
        while (--i >= 0) {
            RubyType name = Unmarshaller.unmarshalRubyType(is);
            if (!(name instanceof RubySymbol)) {
                throw new IOException("Expected only symbols for names of variables");
            }
            if (i == 0) {
                // empty if block
            }
            RubyType value = Unmarshaller.unmarshalRubyType(is);
            ro.put((RubySymbol)name, value);
        }
    }
}

