/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.types;

import com.mfizz.ruby.core.Ruby;
import com.mfizz.ruby.types.RubyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RubyArray
extends RubyType {
    private List<RubyType> array;

    public RubyArray() {
        this.array = new ArrayList<RubyType>();
    }

    public RubyArray(List<RubyType> array) {
        this.array = array;
    }

    public RubyArray(RubyType[] array) {
        this.array = Arrays.asList(array);
    }

    public void add(RubyType element) {
        this.array.add(element);
    }

    public RubyType get(int index) {
        return this.array.get(index);
    }

    public int size() {
        return this.array.size();
    }

    public List<? extends RubyType> getArray() {
        return this.array;
    }

    @Override
    public void inspect(StringBuilder sb, int indent) {
        sb.append("Array[");
        int j = 0;
        for (RubyType o : this.array) {
            if (j == 0) {
                sb.append("\n");
            }
            for (int i = 0; i < indent + 1; ++i) {
                sb.append(" ");
            }
            if (j != 0) {
                sb.append(", ");
            }
            sb.append(Ruby.toString(o, indent + 1));
            sb.append("\n");
            ++j;
        }
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append("]");
    }
}

