/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.types;

import com.mfizz.ruby.core.Ruby;
import com.mfizz.ruby.types.RubyType;
import java.util.LinkedHashMap;
import java.util.Map;

public class RubyHash
extends RubyType {
    private Map<RubyType, RubyType> map;

    public RubyHash() {
        this.map = new LinkedHashMap<RubyType, RubyType>();
    }

    public RubyHash(Map<RubyType, RubyType> map) {
        this.map = map;
    }

    public RubyType get(RubyType key) {
        return this.map.get(key);
    }

    public RubyType put(RubyType key, RubyType value) {
        return this.map.put(key, value);
    }

    public int size() {
        return this.map.size();
    }

    public Map<RubyType, RubyType> getMap() {
        return this.map;
    }

    @Override
    public void inspect(StringBuilder sb, int indent) {
        sb.append("Hash{");
        int j = 0;
        for (Map.Entry<RubyType, RubyType> entry : this.map.entrySet()) {
            if (j == 0) {
                sb.append("\n");
            }
            for (int i = 0; i < indent + 1; ++i) {
                sb.append(" ");
            }
            sb.append(entry.getKey());
            sb.append(" => ");
            sb.append(Ruby.toString(entry.getValue(), indent + 1));
            sb.append("\n");
            ++j;
        }
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append("}");
    }
}

