/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.types;

import com.mfizz.ruby.core.Ruby;
import com.mfizz.ruby.types.RubySymbol;
import com.mfizz.ruby.types.RubyType;
import java.util.LinkedHashMap;
import java.util.Map;

public class RubyObject
extends RubyType {
    private RubySymbol name;
    private Map<RubySymbol, RubyType> variables;

    public RubyObject(RubySymbol name) {
        this.name = name;
        this.variables = new LinkedHashMap<RubySymbol, RubyType>();
    }

    public RubySymbol getName() {
        return this.name;
    }

    public RubyType get(RubySymbol name) {
        return this.variables.get(name);
    }

    public void put(RubySymbol name, RubyType value) {
        this.variables.put(name, value);
    }

    public int count() {
        return this.variables.size();
    }

    public Map<RubySymbol, RubyType> getVariables() {
        return this.variables;
    }

    @Override
    public void inspect(StringBuilder sb, int indent) {
        sb.append("Object:");
        sb.append(this.name.getName());
        sb.append("(");
        int j = 0;
        for (Map.Entry<RubySymbol, RubyType> entry : this.variables.entrySet()) {
            if (j == 0) {
                sb.append("\n");
            }
            for (int i = 0; i < indent + 1; ++i) {
                sb.append(" ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(Ruby.toString(entry.getValue(), indent + 1));
            sb.append("\n");
            ++j;
        }
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append(")");
    }
}

