/*
 * Decompiled with CFR 0.152.
 */
package com.mfizz.ruby.types;

import com.mfizz.ruby.types.RubyType;
import java.util.Arrays;

public class RubyString
extends RubyType {
    private final byte[] bytes;

    public RubyString(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void inspect(StringBuilder sb, int indent) {
        try {
            sb.append("\"");
            sb.append(new String(this.bytes, "UTF-8"));
            sb.append("\"");
        }
        catch (Exception e) {
            throw new RuntimeException("utf-8 charset doesn't exist?");
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Arrays.hashCode(this.bytes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyString other = (RubyString)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

