/*
 * Decompiled with CFR 0.152.
 */
package ollie;

import android.database.Cursor;
import ollie.Ollie;
import ollie.OllieProvider;
import ollie.annotation.AutoIncrement;
import ollie.annotation.Column;
import ollie.annotation.PrimaryKey;
import ollie.annotation.Table;
import ollie.query.Select;

@Table(value="")
public abstract class Model {
    public static final String _ID = "_id";
    @Column(value="_id")
    @PrimaryKey
    @AutoIncrement
    public Long id;

    public static final <T extends Model> T find(Class<T> cls, Long id) {
        return Select.from(cls).where("_id=?", id).fetchSingle();
    }

    public final void load(Cursor cursor) {
        Ollie.load(this, cursor);
        Ollie.putEntity(this);
    }

    public final Long save() {
        this.id = Ollie.save(this);
        Ollie.putEntity(this);
        this.notifyChange();
        return this.id;
    }

    public final void delete() {
        Ollie.delete(this);
        Ollie.removeEntity(this);
        this.notifyChange();
        this.id = null;
    }

    private void notifyChange() {
        if (OllieProvider.isImplemented()) {
            Ollie.getContext().getContentResolver().notifyChange(OllieProvider.createUri(this.getClass(), this.id), null);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Model && this.id != null) {
            Model other = (Model)obj;
            return Ollie.getTableName(this.getClass()).equals(Ollie.getTableName(other.getClass())) && this.id.equals(other.id);
        }
        return this == obj;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.getClass().getName().hashCode();
        hash = hash * 31 + (this.id != null ? this.id.intValue() : super.hashCode());
        return hash;
    }
}

