/*
 * Decompiled with CFR 0.152.
 */
package ollie;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQuery;
import android.os.Build;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import ollie.Migration;
import ollie.Model;
import ollie.TypeAdapter;
import ollie.internal.AdapterHolder;
import ollie.internal.ModelAdapter;

public final class Ollie {
    public static final int DEFAULT_CACHE_SIZE = 1024;
    private static final String TAG = "Ollie";
    private static Context sContext;
    private static AdapterHolder sAdapterHolder;
    private static DatabaseHelper sDatabaseHelper;
    private static SQLiteDatabase sSQLiteDatabase;
    private static LruCache<String, Model> sCache;
    private static LogLevel sLogLevel;
    private static boolean sInitialized;

    private Ollie() {
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    public static void init(Context context, String name, int version) {
        Ollie.init(context, name, version, 1024, LogLevel.NONE);
    }

    public static void init(Context context, String name, int version, int cacheSize) {
        Ollie.init(context, name, version, cacheSize, LogLevel.NONE);
    }

    public static void init(Context context, String name, int version, LogLevel logLevel) {
        Ollie.init(context, name, version, 1024, logLevel);
    }

    public static void init(Context context, String name, int version, int cacheSize, LogLevel logLevel) {
        block4: {
            sLogLevel = logLevel;
            if (sInitialized) {
                if (sLogLevel.log(LogLevel.BASIC)) {
                    Log.d((String)TAG, (String)"Already initialized.");
                }
                return;
            }
            try {
                Class<?> adapterClass = Class.forName("ollie.AdapterHolderImpl");
                sAdapterHolder = (AdapterHolder)adapterClass.newInstance();
            }
            catch (Exception e) {
                if (!sLogLevel.log(LogLevel.BASIC)) break block4;
                Log.e((String)TAG, (String)"Failed to initialize.", (Throwable)e);
            }
        }
        sContext = context.getApplicationContext();
        sDatabaseHelper = new DatabaseHelper(sContext, name, version);
        sSQLiteDatabase = sDatabaseHelper.getWritableDatabase();
        sCache = new LruCache(cacheSize);
        sInitialized = true;
    }

    public static Context getContext() {
        return sContext;
    }

    public static SQLiteDatabase getDatabase() {
        return sSQLiteDatabase;
    }

    public static <T extends Model> String getTableName(Class<T> cls) {
        return sAdapterHolder.getModelAdapter(cls).getTableName();
    }

    public static <T extends Model> List<T> processCursor(Class<T> cls, Cursor cursor) {
        ArrayList<T> entities = new ArrayList<T>();
        try {
            Constructor<T> entityConstructor = cls.getConstructor(new Class[0]);
            if (cursor.moveToFirst()) {
                do {
                    Object entity;
                    if ((entity = Ollie.getEntity(cls, cursor.getLong(cursor.getColumnIndex("_id")))) == null) {
                        entity = (Model)entityConstructor.newInstance(new Object[0]);
                    }
                    ((Model)entity).load(cursor);
                    entities.add(entity);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to process cursor.", (Throwable)e);
        }
        return entities;
    }

    public static <T extends Model> List<T> processAndCloseCursor(Class<T> cls, Cursor cursor) {
        List<T> entities = Ollie.processCursor(cls, cursor);
        cursor.close();
        return entities;
    }

    static <D, S> TypeAdapter<D, S> getTypeAdapter(Class<D> cls) {
        return sAdapterHolder.getTypeAdapter(cls);
    }

    static List<? extends ModelAdapter> getModelAdapters() {
        return sAdapterHolder.getModelAdapters();
    }

    static synchronized <T extends Model> void putEntity(T entity) {
        if (entity.id != null) {
            sCache.put((Object)Ollie.getEntityIdentifier(entity.getClass(), entity.id), entity);
        }
    }

    static synchronized <T extends Model> T getEntity(Class<T> cls, long id) {
        return (T)((Model)sCache.get((Object)Ollie.getEntityIdentifier(cls, id)));
    }

    static synchronized <T extends Model> void removeEntity(T entity) {
        sCache.remove((Object)Ollie.getEntityIdentifier(entity.getClass(), entity.id));
    }

    static synchronized <T extends Model> T getOrFindEntity(Class<T> cls, long id) {
        T entity = Ollie.getEntity(cls, id);
        if (entity == null) {
            entity = Model.find(cls, id);
        }
        return entity;
    }

    static synchronized <T extends Model> void load(T entity, Cursor cursor) {
        sAdapterHolder.getModelAdapter(entity.getClass()).load(entity, cursor);
    }

    static synchronized <T extends Model> Long save(T entity) {
        return sAdapterHolder.getModelAdapter(entity.getClass()).save(entity, sSQLiteDatabase);
    }

    static synchronized <T extends Model> void delete(T entity) {
        sAdapterHolder.getModelAdapter(entity.getClass()).delete(entity, sSQLiteDatabase);
    }

    private static String getEntityIdentifier(Class<? extends Model> cls, long id) {
        return cls.getName() + "@" + id;
    }

    static {
        sLogLevel = LogLevel.NONE;
        sInitialized = false;
    }

    private static final class LoggingCursorAdapter
    implements SQLiteDatabase.CursorFactory {
        private LoggingCursorAdapter() {
        }

        public Cursor newCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
            Log.v((String)Ollie.TAG, (String)query.toString());
            return new SQLiteCursor(db, driver, editTable, query);
        }
    }

    private static final class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context, String name, int version) {
            super(context, name, (SQLiteDatabase.CursorFactory)(sLogLevel.log(LogLevel.FULL) ? new LoggingCursorAdapter() : null), version);
        }

        public void onOpen(SQLiteDatabase db) {
            this.executePragmas(db);
        }

        public void onCreate(SQLiteDatabase db) {
            this.executePragmas(db);
            this.executeCreate(db);
            this.executeMigrations(db, -1, db.getVersion());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.executePragmas(db);
            this.executeCreate(db);
            this.executeMigrations(db, oldVersion, newVersion);
        }

        private void executePragmas(SQLiteDatabase db) {
            if (Build.VERSION.SDK_INT >= 8) {
                db.execSQL("PRAGMA foreign_keys=ON;");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCreate(SQLiteDatabase db) {
            ArrayList<String> tableDefinitions = new ArrayList<String>();
            for (ModelAdapter modelAdapter : sAdapterHolder.getModelAdapters()) {
                tableDefinitions.add(modelAdapter.getSchema());
            }
            db.beginTransaction();
            try {
                for (String string : tableDefinitions) {
                    db.execSQL(string);
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeMigrations(SQLiteDatabase db, int oldVersion, int newVersion) {
            boolean migrationExecuted = false;
            List<? extends Migration> migrations = sAdapterHolder.getMigrations();
            db.beginTransaction();
            try {
                for (Migration migration : migrations) {
                    if (migration.getVersion() <= oldVersion || migration.getVersion() > newVersion) continue;
                    for (String statement : migration.getStatements()) {
                        db.execSQL(statement);
                    }
                    migrationExecuted = true;
                }
            }
            finally {
                db.setTransactionSuccessful();
            }
            db.endTransaction();
            return migrationExecuted;
        }
    }

    public static final class Builder {
        private Context mContext;
        private String mName;
        private int mVersion;
        private int mCacheSize;
        private LogLevel mLogLevel;

        public Builder(Context context) {
            this.mContext = context;
            this.mName = context.getPackageName();
            this.mVersion = 1;
            this.mCacheSize = 1024;
            this.mLogLevel = LogLevel.NONE;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setVersion(int version) {
            this.mVersion = version;
            return this;
        }

        public Builder setCacheSize(int cacheSize) {
            this.mCacheSize = cacheSize;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            this.mLogLevel = logLevel;
            return this;
        }

        public void init() {
            Ollie.init(this.mContext, this.mName, this.mVersion, this.mCacheSize, this.mLogLevel);
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        FULL;


        public boolean log(LogLevel logLevel) {
            return this.ordinal() >= logLevel.ordinal();
        }
    }
}

