/*
 * Decompiled with CFR 0.152.
 */
package ollie;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.util.SparseArray;
import ollie.Model;
import ollie.Ollie;
import ollie.internal.ModelAdapter;

public abstract class OllieProvider
extends ContentProvider {
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final SparseArray<Class<? extends Model>> TYPE_CODES = new SparseArray();
    private static boolean sIsImplemented = false;
    private static String sAuthority;
    private static SparseArray<String> sMimeTypeCache;

    public static boolean isImplemented() {
        return sIsImplemented;
    }

    public static Uri createUri(Class<? extends Model> type) {
        return OllieProvider.createUri(type, null);
    }

    public static Uri createUri(Class<? extends Model> type, Long id) {
        StringBuilder uri = new StringBuilder();
        uri.append("content://");
        uri.append(sAuthority);
        uri.append("/");
        uri.append(Ollie.getTableName(type).toLowerCase());
        if (id != null) {
            uri.append("/");
            uri.append(id.toString());
        }
        return Uri.parse((String)uri.toString());
    }

    public boolean onCreate() {
        Ollie.init(this.getContext(), this.getDatabaseName(), this.getDatabaseVersion(), this.getCacheSize(), this.getLogLevel());
        sAuthority = this.getAuthority();
        sIsImplemented = true;
        int i = 0;
        for (ModelAdapter modelAdapter : Ollie.getModelAdapters()) {
            int tableKey = i * 2 + 1;
            int itemKey = i * 2 + 2;
            URI_MATCHER.addURI(sAuthority, modelAdapter.getTableName().toLowerCase(), tableKey);
            TYPE_CODES.put(tableKey, modelAdapter.getModelType());
            URI_MATCHER.addURI(sAuthority, modelAdapter.getTableName().toLowerCase() + "/#", itemKey);
            TYPE_CODES.put(itemKey, modelAdapter.getModelType());
            ++i;
        }
        return true;
    }

    public String getType(Uri uri) {
        int match = URI_MATCHER.match(uri);
        String cachedMimeType = (String)sMimeTypeCache.get(match);
        if (cachedMimeType != null) {
            return cachedMimeType;
        }
        Class<? extends Model> type = this.getModelType(uri);
        boolean single = match % 2 == 0;
        StringBuilder mimeType = new StringBuilder();
        mimeType.append("vnd");
        mimeType.append(".");
        mimeType.append(sAuthority);
        mimeType.append(".");
        mimeType.append(single ? "item" : "dir");
        mimeType.append("/");
        mimeType.append("vnd");
        mimeType.append(".");
        mimeType.append(sAuthority);
        mimeType.append(".");
        mimeType.append(Ollie.getTableName(type));
        sMimeTypeCache.append(match, (Object)mimeType.toString());
        return mimeType.toString();
    }

    public Uri insert(Uri uri, ContentValues values) {
        Class<? extends Model> type = this.getModelType(uri);
        Long id = Ollie.getDatabase().insert(Ollie.getTableName(type), null, values);
        if (id != null && id > 0L) {
            Uri retUri = OllieProvider.createUri(type, id);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return retUri;
        }
        return null;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count = Ollie.getDatabase().update(Ollie.getTableName(this.getModelType(uri)), values, selection, selectionArgs);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count = Ollie.getDatabase().delete(Ollie.getTableName(this.getModelType(uri)), selection, selectionArgs);
        this.getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor = Ollie.getDatabase().query(Ollie.getTableName(this.getModelType(uri)), projection, selection, selectionArgs, null, null, sortOrder);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    protected abstract String getDatabaseName();

    protected abstract int getDatabaseVersion();

    protected String getAuthority() {
        return this.getContext().getPackageName();
    }

    protected int getCacheSize() {
        return 1024;
    }

    protected Ollie.LogLevel getLogLevel() {
        return Ollie.LogLevel.NONE;
    }

    private Class<? extends Model> getModelType(Uri uri) {
        int code = URI_MATCHER.match(uri);
        if (code != -1) {
            return (Class)TYPE_CODES.get(code);
        }
        return null;
    }

    static {
        sMimeTypeCache = new SparseArray();
    }
}

