/*
 * Decompiled with CFR 0.152.
 */
package ollie.query;

import android.text.TextUtils;
import ollie.Model;
import ollie.Ollie;
import ollie.query.ExecutableQueryBase;
import ollie.query.Query;
import ollie.query.QueryBase;

public final class Insert
extends QueryBase {
    private Insert() {
        super(null, null);
    }

    public static <T extends Model> Into<T> into(Class<T> table) {
        return new Into(new Insert(), table);
    }

    @Override
    public String getPartSql() {
        return "INSERT";
    }

    public static final class Values<T extends Model>
    extends ExecutableQueryBase<T> {
        private Object[] mValuesArgs;

        private Values(Query parent, Class<T> table, Object[] args) {
            super(parent, table);
            this.mValuesArgs = args;
        }

        @Override
        protected String getPartSql() {
            StringBuilder builder = new StringBuilder();
            builder.append("VALUES(");
            for (int i = 0; i < this.mValuesArgs.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append("?");
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String[] getPartArgs() {
            return this.toStringArray(this.mValuesArgs);
        }
    }

    public static final class Columns<T extends Model>
    extends QueryBase<T> {
        private String[] mColumns;

        public Columns(Query parent, Class<T> table, String[] columns) {
            super(parent, table);
            this.mColumns = columns;
        }

        public Values<T> values(Object ... args) {
            if (this.mColumns.length != args.length) {
                throw new Query.MalformedQueryException("Number of columns does not match number of values.");
            }
            return new Values(this, this.mTable, args);
        }

        @Override
        protected String getPartSql() {
            StringBuilder builder = new StringBuilder();
            if (this.mColumns != null && this.mColumns.length > 0) {
                builder.append("(").append(TextUtils.join((CharSequence)", ", (Object[])this.mColumns)).append(")");
            }
            return builder.toString();
        }
    }

    public static final class Into<T extends Model>
    extends QueryBase<T> {
        private Into(Query parent, Class<T> table) {
            super(parent, table);
        }

        public Columns<T> columns(String ... columns) {
            return new Columns(this, this.mTable, columns);
        }

        public Values<T> values(Object ... args) {
            return new Values(this, this.mTable, args);
        }

        @Override
        protected String getPartSql() {
            StringBuilder builder = new StringBuilder();
            builder.append("INTO ");
            builder.append(Ollie.getTableName(this.mTable));
            return builder.toString();
        }
    }
}

