/*
 * Decompiled with CFR 0.152.
 */
package ollie.query;

import ollie.Model;
import ollie.query.Query;

public abstract class QueryBase<T extends Model>
implements Query {
    protected Query mParent;
    protected Class<T> mTable;

    public QueryBase(Query parent, Class<T> table) {
        this.mParent = parent;
        this.mTable = table;
    }

    @Override
    public final String getSql() {
        if (this.mParent != null) {
            return this.mParent.getSql() + " " + this.getPartSql().trim();
        }
        return this.getPartSql().trim();
    }

    @Override
    public final String[] getArgs() {
        if (this.mParent != null) {
            return this.join(this.mParent.getArgs(), this.getPartArgs());
        }
        return this.getPartArgs();
    }

    protected String getPartSql() {
        return null;
    }

    protected String[] getPartArgs() {
        return null;
    }

    protected final String[] toStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        String[] transformedArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            transformedArray[i] = String.valueOf(array[i]);
        }
        return transformedArray;
    }

    private final String[] join(String[] array1, String ... array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        String[] joinedArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    private final String[] clone(String[] array) {
        if (array == null) {
            return null;
        }
        return (String[])array.clone();
    }
}

