/*
 * Decompiled with CFR 0.152.
 */
package ollie.query;

import android.database.Cursor;
import java.util.List;
import ollie.Model;
import ollie.Ollie;
import ollie.query.Query;
import ollie.query.QueryBase;
import ollie.query.ResultQuery;
import ollie.util.QueryUtils;
import rx.Observable;
import rx.Subscriber;

public abstract class ResultQueryBase<T extends Model>
extends QueryBase<T>
implements ResultQuery<T> {
    public ResultQueryBase(Query parent, Class<T> table) {
        super(parent, table);
    }

    @Override
    public List<T> fetch() {
        return QueryUtils.rawQuery(this.mTable, this.getSql(), this.getArgs());
    }

    @Override
    public T fetchSingle() {
        List results = QueryUtils.rawQuery(this.mTable, this.getSql(), this.getArgs());
        if (!results.isEmpty()) {
            return (T)((Model)results.get(0));
        }
        return null;
    }

    @Override
    public <E> E fetchValue(Class<E> type) {
        Cursor cursor = Ollie.getDatabase().rawQuery(this.getSql(), this.getArgs());
        if (!cursor.moveToFirst()) {
            return null;
        }
        if (type.equals(Byte[].class) || type.equals(byte[].class)) {
            return (E)cursor.getBlob(0);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return (E)Double.valueOf(cursor.getDouble(0));
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return (E)Float.valueOf(cursor.getFloat(0));
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (E)Integer.valueOf(cursor.getInt(0));
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (E)Long.valueOf(cursor.getLong(0));
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (E)Short.valueOf(cursor.getShort(0));
        }
        if (type.equals(String.class)) {
            return (E)cursor.getString(0);
        }
        return null;
    }

    @Override
    public Observable<List<T>> observable() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<T>>(){

            public void call(Subscriber<? super List<T>> subscriber) {
                List result = ResultQueryBase.this.fetch();
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext(result);
                    subscriber.onCompleted();
                }
            }
        });
    }

    @Override
    public Observable<T> observableSingle() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                Object result = ResultQueryBase.this.fetchSingle();
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext(result);
                    subscriber.onCompleted();
                }
            }
        });
    }

    @Override
    public <E> Observable<E> observableValue(final Class<E> type) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<E>(){

            public void call(Subscriber<? super E> subscriber) {
                Object result = ResultQueryBase.this.fetchValue(type);
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext(result);
                    subscriber.onCompleted();
                }
            }
        });
    }
}

