/*
 * Decompiled with CFR 0.152.
 */
package ollie.query;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import ollie.Model;
import ollie.Ollie;
import ollie.query.Query;
import ollie.query.QueryBase;
import ollie.query.ResultQueryBase;

public final class Select<T extends Model>
extends QueryBase<T> {
    private Select() {
        super(null, null);
    }

    public static <T extends Model> Columns<T> columns(String ... columns) {
        return new Columns(new Select<T>(), null, columns);
    }

    public static <T extends Model> From<T> from(Class<T> table) {
        return new Columns<T>(new Select<T>(), table, null).from(table);
    }

    @Override
    public String getPartSql() {
        return "SELECT";
    }

    public static final class Offset<T extends Model>
    extends ResultQueryBase<T> {
        private String mOffset;

        private Offset(Query parent, Class<T> table, String offset) {
            super(parent, table);
            this.mOffset = offset;
        }

        @Override
        protected String getPartSql() {
            return "OFFSET " + this.mOffset;
        }
    }

    public static final class Limit<T extends Model>
    extends ResultQueryBase<T> {
        private String mLimit;

        private Limit(Query parent, Class<T> table, String limit) {
            super(parent, table);
            this.mLimit = limit;
        }

        public Offset<T> offset(String offset) {
            return new Offset(this, this.mTable, offset);
        }

        @Override
        public String getPartSql() {
            return "LIMIT " + this.mLimit;
        }
    }

    public static final class OrderBy<T extends Model>
    extends ResultQueryBase<T> {
        private String mOrderBy;

        private OrderBy(Query parent, Class<T> table, String orderBy) {
            super(parent, table);
            this.mOrderBy = orderBy;
        }

        public Limit<T> limit(String limits) {
            return new Limit(this, this.mTable, limits);
        }

        @Override
        public String getPartSql() {
            return "ORDER BY " + this.mOrderBy;
        }
    }

    public static final class Having<T extends Model>
    extends ResultQueryBase<T> {
        private String mHaving;

        private Having(Query parent, Class<T> table, String having) {
            super(parent, table);
            this.mHaving = having;
        }

        public OrderBy<T> orderBy(String orderBy) {
            return new OrderBy(this, this.mTable, orderBy);
        }

        public Limit<T> limit(String limits) {
            return new Limit(this, this.mTable, limits);
        }

        @Override
        public String getPartSql() {
            return "HAVING " + this.mHaving;
        }
    }

    public static final class GroupBy<T extends Model>
    extends ResultQueryBase<T> {
        private String mGroupBy;

        private GroupBy(Query parent, Class<T> table, String groupBy) {
            super(parent, table);
            this.mGroupBy = groupBy;
        }

        public Having<T> having(String having) {
            return new Having(this, this.mTable, having);
        }

        public OrderBy<T> orderBy(String orderBy) {
            return new OrderBy(this, this.mTable, orderBy);
        }

        public Limit<T> limit(String limits) {
            return new Limit(this, this.mTable, limits);
        }

        @Override
        public String getPartSql() {
            return "GROUP BY " + this.mGroupBy;
        }
    }

    public static final class Where<T extends Model>
    extends ResultQueryBase<T> {
        private String mWhere;
        private Object[] mWhereArgs;

        private Where(Query parent, Class<T> table, String where, Object[] args) {
            super(parent, table);
            this.mWhere = where;
            this.mWhereArgs = args;
        }

        public GroupBy<T> groupBy() {
            return null;
        }

        public OrderBy<T> orderBy(String orderBy) {
            return new OrderBy(this, this.mTable, orderBy);
        }

        public Limit<T> limit(String limits) {
            return new Limit(this, this.mTable, limits);
        }

        @Override
        public String getPartSql() {
            return "WHERE " + this.mWhere;
        }

        @Override
        public String[] getPartArgs() {
            return this.toStringArray(this.mWhereArgs);
        }
    }

    public static final class Join<P extends Model, T extends Model>
    extends QueryBase<T> {
        private Type mType;
        private String mConstraint;

        private Join(From<P> parent, Class<T> table, Type type) {
            super(parent, table);
            this.mType = type;
        }

        public From<P> on(String constraint) {
            this.mConstraint = "ON " + constraint;
            return (From)this.mParent;
        }

        public From<P> using(String ... columns) {
            this.mConstraint = "USING (" + TextUtils.join((CharSequence)", ", (Object[])columns) + ")";
            return (From)this.mParent;
        }

        @Override
        public String getPartSql() {
            return this.mType.getKeyword() + " " + Ollie.getTableName(this.mTable) + " " + this.mConstraint;
        }

        public static enum Type {
            JOIN("JOIN"),
            LEFT("LEFT JOIN"),
            LEFT_OUTER("LEFT OUTER JOIN"),
            INNER("INNER JOIN"),
            CROSS("CROSS JOIN"),
            NATURAL_JOIN("NATURAL JOIN"),
            NATURAL_LEFT("NATURAL LEFT JOIN"),
            NATURAL_LEFT_OUTER("NATURAL LEFT OUTER JOIN"),
            NATURAL_INNER("NATURAL INNER JOIN"),
            NATURAL_CROSS("NATURAL CROSS JOIN");

            private String mKeyword;

            private Type(String keyword) {
                this.mKeyword = keyword;
            }

            public String getKeyword() {
                return this.mKeyword;
            }
        }
    }

    public static final class From<T extends Model>
    extends ResultQueryBase<T> {
        private List<Join> mJoins = new ArrayList<Join>();

        private From(Query parent, Class<T> table) {
            super(parent, table);
        }

        public <E extends Model> Join<T, E> join(Class<E> table) {
            return this.addJoin(table, Join.Type.JOIN);
        }

        public <E extends Model> Join<T, E> leftJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.LEFT);
        }

        public <E extends Model> Join<T, E> leftOuterJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.LEFT_OUTER);
        }

        public <E extends Model> Join<T, E> innerJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.INNER);
        }

        public <E extends Model> Join<T, E> crossJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.CROSS);
        }

        public <E extends Model> Join<T, E> naturalJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.NATURAL_JOIN);
        }

        public <E extends Model> Join<T, E> naturalLeftJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.NATURAL_LEFT);
        }

        public <E extends Model> Join<T, E> naturalLeftOuterJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.NATURAL_LEFT_OUTER);
        }

        public <E extends Model> Join<T, E> naturalInnerJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.NATURAL_INNER);
        }

        public <E extends Model> Join<T, E> naturalCrossJoin(Class<E> table) {
            return this.addJoin(table, Join.Type.NATURAL_CROSS);
        }

        public Where<T> where(String where) {
            return new Where(this, this.mTable, where, null);
        }

        public Where<T> where(String where, Object ... args) {
            return new Where(this, this.mTable, where, args);
        }

        public GroupBy<T> groupBy(String groupBy) {
            return new GroupBy(this, this.mTable, groupBy);
        }

        public OrderBy<T> orderBy(String orderBy) {
            return new OrderBy(this, this.mTable, orderBy);
        }

        public Limit<T> limit(String limit) {
            return new Limit(this, this.mTable, limit);
        }

        private <E extends Model> Join<T, E> addJoin(Class<E> table, Join.Type type) {
            Join join = new Join(this, table, type);
            this.mJoins.add(join);
            return join;
        }

        @Override
        public String getPartSql() {
            StringBuilder builder = new StringBuilder();
            builder.append("FROM ");
            builder.append(Ollie.getTableName(this.mTable)).append(" ");
            for (Join join : this.mJoins) {
                builder.append(join.getPartSql()).append(" ");
            }
            return builder.toString();
        }
    }

    public static final class Columns<T extends Model>
    extends QueryBase<T> {
        private String[] mColumns;

        public Columns(Query parent, Class<T> table, String[] columns) {
            super(parent, table);
            this.mColumns = columns;
        }

        public <T extends Model> From<T> from(Class<T> table) {
            return new From(this, table);
        }

        @Override
        public String getPartSql() {
            StringBuilder builder = new StringBuilder();
            if (this.mColumns != null && this.mColumns.length > 0) {
                builder.append(TextUtils.join((CharSequence)", ", (Object[])this.mColumns)).append(" ");
            } else {
                builder.append(Ollie.getTableName(this.mTable)).append(".* ");
            }
            return builder.toString();
        }
    }
}

