/*
 * Decompiled with CFR 0.152.
 */
package replpp.server;

import dotty.tools.repl.State;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import replpp.server.EmbeddedRepl$;
import replpp.server.QueryResult;
import replpp.server.QueryResult$;
import replpp.server.ReplDriver;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;

public class EmbeddedRepl {
    private final Seq<String> runAfterCode;
    private final boolean verbose;
    private final Logger logger;
    private final ByteArrayOutputStream replOutputStream;
    private final ReplDriver replDriver;
    private State state;
    private final ExecutionContextExecutorService singleThreadedJobExecutor;

    public static Seq<String> $lessinit$greater$default$2() {
        return EmbeddedRepl$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$3() {
        return EmbeddedRepl$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return EmbeddedRepl$.MODULE$.$lessinit$greater$default$4();
    }

    public EmbeddedRepl(String[] compilerArgs, Seq<String> runBeforeCode, Seq<String> runAfterCode, boolean verbose) {
        this.runAfterCode = runAfterCode;
        this.verbose = verbose;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.replOutputStream = new ByteArrayOutputStream();
        this.replDriver = new ReplDriver(compilerArgs, new PrintStream(this.replOutputStream), (Option<ClassLoader>)None$.MODULE$);
        this.state = runBeforeCode.nonEmpty() ? this.replDriver.execute((IterableOnce<String>)runBeforeCode, this.replDriver.execute$default$2((IterableOnce<String>)runBeforeCode)) : this.replDriver.initialState();
        this.singleThreadedJobExecutor = ExecutionContext$.MODULE$.fromExecutorService(Executors.newSingleThreadExecutor());
    }

    public Tuple2<UUID, Future<String>> queryAsync(String code) {
        return this.queryAsync((IterableOnce<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(code)));
    }

    public Tuple2<UUID, Future<String>> queryAsync(IterableOnce<String> inputLines) {
        UUID uuid = UUID.randomUUID();
        Future future = Future$.MODULE$.apply(() -> this.$anonfun$1(inputLines), (ExecutionContext)this.singleThreadedJobExecutor);
        return Tuple2$.MODULE$.apply((Object)uuid, (Object)future);
    }

    private String readAndResetReplOutputStream() {
        String result = this.replOutputStream.toString(StandardCharsets.UTF_8);
        this.replOutputStream.reset();
        return result;
    }

    public QueryResult query(String code) {
        return this.query((IterableOnce<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(code)));
    }

    public QueryResult query(IterableOnce<String> inputLines) {
        Tuple2<UUID, Future<String>> tuple2 = this.queryAsync(inputLines);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        UUID uuid = (UUID)tuple2._1();
        Future futureResult = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)uuid, (Object)futureResult);
        UUID uuid2 = (UUID)tuple22._1();
        Future futureResult2 = (Future)tuple22._2();
        String result = (String)Await$.MODULE$.result((Awaitable)futureResult2, (Duration)Duration$.MODULE$.Inf());
        return QueryResult$.MODULE$.apply(result, uuid2, true);
    }

    public void shutdown() {
        this.logger.info("shutting down");
        if (this.runAfterCode.nonEmpty()) {
            if (this.verbose) {
                this.logger.info("executing: " + this.runAfterCode);
            }
            this.replDriver.execute((IterableOnce<String>)this.runAfterCode, this.replDriver.execute$default$2((IterableOnce<String>)this.runAfterCode));
        }
        this.singleThreadedJobExecutor.shutdown();
    }

    private final String $anonfun$1(IterableOnce inputLines$1) {
        this.state = this.replDriver.execute((IterableOnce<String>)inputLines$1, this.state);
        return this.readAndResetReplOutputStream();
    }
}

