/*
 * Decompiled with CFR 0.152.
 */
package replpp.server;

import cask.endpoints.JsReader$;
import cask.endpoints.JsonData$;
import cask.endpoints.QueryParamReader;
import cask.endpoints.WebsocketResult;
import cask.endpoints.get;
import cask.endpoints.get$;
import cask.endpoints.postJson;
import cask.endpoints.postJson$;
import cask.endpoints.websocket;
import cask.endpoints.websocket$;
import cask.internal.Conversion$;
import cask.model.Response;
import cask.model.Response$;
import cask.router.ArgReader;
import cask.router.ArgSig;
import cask.router.ArgSig$;
import cask.router.Endpoint;
import cask.router.EndpointMetadata$;
import cask.router.EntryPoint;
import cask.router.EntryPoint$;
import cask.router.NoOpParser$;
import cask.router.RoutesEndpointsMetadata;
import cask.router.RoutesEndpointsMetadata$;
import cask.router.Runtime$;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.UUID;
import replpp.server.Config;
import replpp.server.EmbeddedRepl;
import replpp.server.QueryResult;
import replpp.server.QueryResult$;
import replpp.server.ReplServer$;
import replpp.server.UsernamePasswordAuth;
import replpp.server.WebServiceWithWebSocket;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import ujson.Obj;
import ujson.Obj$;
import ujson.Value$;
import upickle.default$;

public class ReplServer
extends WebServiceWithWebSocket<QueryResult> {
    private final EmbeddedRepl repl;

    public static void startHttpServer(Config config) {
        ReplServer$.MODULE$.startHttpServer(config);
    }

    public static Option<UsernamePasswordAuth> $lessinit$greater$default$4() {
        return ReplServer$.MODULE$.$lessinit$greater$default$4();
    }

    public ReplServer(EmbeddedRepl repl, String host, int port, Option<UsernamePasswordAuth> authenticationMaybe) {
        this.repl = repl;
        super(host, port, authenticationMaybe);
        ReplServer Routes_this = this;
        EntryPoint entrypoint = EntryPoint$.MODULE$.apply("postQuery", (Seq)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("query", "String", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)JsReader$.MODULE$.defaultJsReader(default$.MODULE$.StringReader())), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("isAuthorized", "Boolean", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)NoOpParser$.MODULE$.instanceAnyRequest()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Function4 & Serializable)(clazz, ctxs, argss, sigss) -> {
            Seq parsedArgss = (Seq)sigss.lazyZip((Iterable)argss).lazyZip((Iterable)ctxs).map((Function3 & Serializable)(x$12, x$2, x$3) -> {
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$12, x$2, x$3);
                if (tuple3 != null) {
                    Seq sigs = (Seq)tuple3._1();
                    Map args = (Map)tuple3._2();
                    Object ctx = tuple3._3();
                    return (Seq)sigs.map((Function1 & Serializable)x$1 -> {
                        ArgSig argSig;
                        ArgSig sig = argSig = x$1;
                        return Runtime$.MODULE$.makeReadCall(args, ctx, () -> ReplServer.$anonfun$2$$anonfun$1$$anonfun$1(sig, clazz), sig);
                    });
                }
                throw new MatchError((Object)tuple3);
            }, BuildFrom$.MODULE$.buildFromIterableOps());
            return Runtime$.MODULE$.validateLists(parsedArgss).map((Function1 & Serializable)validated -> {
                Response<Obj> result = this.postQuery((String)((SeqOps)validated.apply(0)).apply(0), BoxesRunTime.unboxToBoolean((Object)((SeqOps)validated.apply(1)).apply(0)));
                return Conversion$.MODULE$.create((Function1 & Serializable)t2 -> JsonData$.MODULE$.dataResponse2(t2, (Function1 & Serializable)t -> JsonData$.MODULE$.JsonDataImpl(t, default$.MODULE$.JsObjW()))).f().apply(result);
            });
        });
        EntryPoint entrypoint2 = EntryPoint$.MODULE$.apply("getResult", (Seq)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("uuidParam", "String", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)QueryParamReader.StringParam$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("isAuthorized", "Boolean", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)NoOpParser$.MODULE$.instanceAnyRequest()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Function4 & Serializable)(clazz, ctxs, argss, sigss) -> {
            Seq parsedArgss = (Seq)sigss.lazyZip((Iterable)argss).lazyZip((Iterable)ctxs).map((Function3 & Serializable)(x$12, x$2, x$3) -> {
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$12, x$2, x$3);
                if (tuple3 != null) {
                    Seq sigs = (Seq)tuple3._1();
                    Map args = (Map)tuple3._2();
                    Object ctx = tuple3._3();
                    return (Seq)sigs.map((Function1 & Serializable)x$1 -> {
                        ArgSig argSig;
                        ArgSig sig = argSig = x$1;
                        return Runtime$.MODULE$.makeReadCall(args, ctx, () -> ReplServer.$anonfun$4$$anonfun$1$$anonfun$1(sig, clazz), sig);
                    });
                }
                throw new MatchError((Object)tuple3);
            }, BuildFrom$.MODULE$.buildFromIterableOps());
            return Runtime$.MODULE$.validateLists(parsedArgss).map((Function1 & Serializable)validated -> {
                Response<Obj> result = this.getResult((String)((SeqOps)validated.apply(0)).apply(0), BoxesRunTime.unboxToBoolean((Object)((SeqOps)validated.apply(1)).apply(0)));
                return Conversion$.MODULE$.create((Function1 & Serializable)t -> Response.Data$.MODULE$.dataResponse2(t, (Function1 & Serializable)s -> Response.Data$.MODULE$.WritableData(s, Predef$.MODULE$.$conforms()))).f().apply(result);
            });
        });
        EntryPoint entrypoint3 = EntryPoint$.MODULE$.apply("postQuerySimple", (Seq)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("query", "String", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)JsReader$.MODULE$.defaultJsReader(default$.MODULE$.StringReader())), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)ArgSig$.MODULE$.apply("isAuthorized", "Boolean", (Option)None$.MODULE$, (Option)None$.MODULE$, (ArgReader)NoOpParser$.MODULE$.instanceAnyRequest()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Function4 & Serializable)(clazz, ctxs, argss, sigss) -> {
            Seq parsedArgss = (Seq)sigss.lazyZip((Iterable)argss).lazyZip((Iterable)ctxs).map((Function3 & Serializable)(x$12, x$2, x$3) -> {
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$12, x$2, x$3);
                if (tuple3 != null) {
                    Seq sigs = (Seq)tuple3._1();
                    Map args = (Map)tuple3._2();
                    Object ctx = tuple3._3();
                    return (Seq)sigs.map((Function1 & Serializable)x$1 -> {
                        ArgSig argSig;
                        ArgSig sig = argSig = x$1;
                        return Runtime$.MODULE$.makeReadCall(args, ctx, () -> ReplServer.$anonfun$6$$anonfun$1$$anonfun$1(sig, clazz), sig);
                    });
                }
                throw new MatchError((Object)tuple3);
            }, BuildFrom$.MODULE$.buildFromIterableOps());
            return Runtime$.MODULE$.validateLists(parsedArgss).map((Function1 & Serializable)validated -> {
                Response<Obj> result = this.postQuerySimple((String)((SeqOps)validated.apply(0)).apply(0), BoxesRunTime.unboxToBoolean((Object)((SeqOps)validated.apply(1)).apply(0)));
                return Conversion$.MODULE$.create((Function1 & Serializable)t2 -> JsonData$.MODULE$.dataResponse2(t2, (Function1 & Serializable)t -> JsonData$.MODULE$.JsonDataImpl(t, default$.MODULE$.JsObjW()))).f().apply(result);
            });
        });
        EntryPoint entrypoint4 = EntryPoint$.MODULE$.apply("handler", (Seq)new .colon.colon((Object)package$.MODULE$.Nil(), (List)Nil$.MODULE$), (Option)None$.MODULE$, (Function4 & Serializable)(clazz, ctxs, argss, sigss) -> {
            Seq parsedArgss = (Seq)sigss.lazyZip((Iterable)argss).lazyZip((Iterable)ctxs).map((Function3 & Serializable)(x$12, x$2, x$3) -> {
                Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$12, x$2, x$3);
                if (tuple3 != null) {
                    Seq sigs = (Seq)tuple3._1();
                    Map args = (Map)tuple3._2();
                    Object ctx = tuple3._3();
                    return (Seq)sigs.map((Function1 & Serializable)x$1 -> {
                        ArgSig argSig;
                        ArgSig sig = argSig = x$1;
                        return Runtime$.MODULE$.makeReadCall(args, ctx, () -> ReplServer.$anonfun$8$$anonfun$1$$anonfun$1(sig, clazz), sig);
                    });
                }
                throw new MatchError((Object)tuple3);
            }, BuildFrom$.MODULE$.buildFromIterableOps());
            return Runtime$.MODULE$.validateLists(parsedArgss).map((Function1 & Serializable)validated -> {
                WebsocketResult result = this.handler();
                return Conversion$.MODULE$.create(Predef$.MODULE$.$conforms()).f().apply((Object)result);
            });
        });
        RoutesEndpointsMetadata routesEndpointsMetadata = RoutesEndpointsMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)EndpointMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new WebServiceWithWebSocket.basicAuth(this), (List)Nil$.MODULE$), (Endpoint)new postJson("/query", postJson$.MODULE$.$lessinit$greater$default$2()), entrypoint), (List)new .colon.colon((Object)EndpointMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new WebServiceWithWebSocket.basicAuth(this), (List)Nil$.MODULE$), (Endpoint)new get("/result/:uuidParam", get$.MODULE$.$lessinit$greater$default$2()), entrypoint2), (List)new .colon.colon((Object)EndpointMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new WebServiceWithWebSocket.basicAuth(this), (List)Nil$.MODULE$), (Endpoint)new postJson("/query-sync", postJson$.MODULE$.$lessinit$greater$default$2()), entrypoint3), (List)new .colon.colon((Object)EndpointMetadata$.MODULE$.apply((Seq)package$.MODULE$.Nil(), (Endpoint)new websocket("/connect", websocket$.MODULE$.$lessinit$greater$default$2()), entrypoint4), (List)Nil$.MODULE$)))));
        Routes_this.cask$main$Routes$$inline$metadata0_$eq(routesEndpointsMetadata);
    }

    private String host$accessor() {
        return super.host();
    }

    private int port$accessor() {
        return super.port();
    }

    @Override
    public WebsocketResult handler() {
        return super.handler();
    }

    @Override
    public Response<Obj> getResult(String uuidParam, boolean isAuthorized) {
        Response<Obj> response = super.getResult(uuidParam, isAuthorized);
        this.logger().debug("GET /result/" + uuidParam + ": statusCode=" + response.statusCode());
        return response;
    }

    public Response<Obj> postQuery(String query, boolean isAuthorized) {
        if (!isAuthorized) {
            return this.unauthorizedResponse();
        }
        Tuple2<UUID, Future<String>> tuple2 = this.repl.queryAsync((IterableOnce<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(query)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        UUID uuid = (UUID)tuple2._1();
        Future resultFuture = (Future)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)uuid, (Object)resultFuture);
        UUID uuid2 = (UUID)tuple22._1();
        Future resultFuture2 = (Future)tuple22._2();
        this.logger().debug("query[uuid=" + uuid2 + ", length=" + query.length() + "]: submitted to queue");
        resultFuture2.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                String output = (String)((Success)try_).value();
                this.logger().debug("query[uuid=" + uuid2 + "]: got result (length=" + output.length() + ")");
                this.returnResult(QueryResult$.MODULE$.apply(output, uuid2, true));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger().info("query[uuid=" + uuid2 + "] failed with " + exception);
                this.returnResult(QueryResult$.MODULE$.apply(this.render(exception), uuid2, false));
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.actorContext());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
        Object[] objectArray = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uuid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Value$.MODULE$.JsonableString((CharSequence)uuid2.toString()));
        return Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i))), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
    }

    public Response<Obj> postQuerySimple(String query, boolean isAuthorized) {
        if (!isAuthorized) {
            return this.unauthorizedResponse();
        }
        this.logger().debug("POST /query-sync query.length=" + query.length());
        QueryResult result = this.repl.query((IterableOnce<String>)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(query)));
        this.logger().debug("query-sync: got result: length=" + result.output().length());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
        Object[] objectArray = new Tuple2[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdout");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Value$.MODULE$.JsonableString((CharSequence)result.output()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uuid");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Value$.MODULE$.JsonableString((CharSequence)result.uuid().toString()));
        return Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i))), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
    }

    @Override
    public Obj resultToJson(QueryResult result, boolean success) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
        Object[] objectArray = new Tuple2[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uuid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Value$.MODULE$.JsonableString((CharSequence)result.uuid().toString()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"stdout");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Value$.MODULE$.JsonableString((CharSequence)result.output()));
        return Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)success)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i)));
    }

    private String render(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return throwable.getMessage() + System.lineSeparator() + sw.toString();
    }

    private static final Option $anonfun$2$$anonfun$1$$anonfun$1(ArgSig sig$1, ReplServer clazz$2) {
        Option option = sig$1.default();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Function1 getter = (Function1)((Some)option).value();
            Object value = getter.apply((Object)clazz$2);
            return Some$.MODULE$.apply(value);
        }
        throw new MatchError((Object)option);
    }

    private static final Option $anonfun$4$$anonfun$1$$anonfun$1(ArgSig sig$2, ReplServer clazz$5) {
        Option option = sig$2.default();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Function1 getter = (Function1)((Some)option).value();
            Object value = getter.apply((Object)clazz$5);
            return Some$.MODULE$.apply(value);
        }
        throw new MatchError((Object)option);
    }

    private static final Option $anonfun$6$$anonfun$1$$anonfun$1(ArgSig sig$3, ReplServer clazz$8) {
        Option option = sig$3.default();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Function1 getter = (Function1)((Some)option).value();
            Object value = getter.apply((Object)clazz$8);
            return Some$.MODULE$.apply(value);
        }
        throw new MatchError((Object)option);
    }

    private static final Option $anonfun$8$$anonfun$1$$anonfun$1(ArgSig sig$4, ReplServer clazz$11) {
        Option option = sig$4.default();
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Function1 getter = (Function1)((Some)option).value();
            Object value = getter.apply((Object)clazz$11);
            return Some$.MODULE$.apply(value);
        }
        throw new MatchError((Object)option);
    }
}

