/*
 * Decompiled with CFR 0.152.
 */
package replpp.server;

import java.io.Serializable;
import java.net.BindException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import replpp.package$;
import replpp.server.Config;
import replpp.server.EmbeddedRepl;
import replpp.server.ReplServer;
import replpp.server.UsernamePasswordAuth;
import replpp.server.UsernamePasswordAuth$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class ReplServer$
implements Serializable {
    private static final Logger logger;
    public static final ReplServer$ MODULE$;

    private ReplServer$() {
    }

    static {
        MODULE$ = new ReplServer$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ReplServer$.class);
    }

    public Option<UsernamePasswordAuth> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Logger logger() {
        return logger;
    }

    public void startHttpServer(Config config) {
        Option authenticationMaybe = config.serverAuthUsername().flatMap((Function1 & Serializable)username -> config.serverAuthPassword().map((Function1 & Serializable)password -> UsernamePasswordAuth$.MODULE$.apply((String)username, (String)password)));
        Seq predefLines = package$.MODULE$.allPredefLines(config.baseConfig());
        String[] compilerArgs = package$.MODULE$.compilerArgs(config.baseConfig());
        EmbeddedRepl embeddedRepl = new EmbeddedRepl(compilerArgs, (IterableOnce<String>)predefLines);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            MODULE$.logger().info("Shutting down server...");
            embeddedRepl.shutdown();
        }));
        ReplServer server = new ReplServer(embeddedRepl, config.serverHost(), config.serverPort(), (Option<UsernamePasswordAuth>)authenticationMaybe);
        this.logger().info("Starting REPL server ...");
        try {
            server.main((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        catch (BindException bindException) {
            this.logger().error("Could not bind socket on port " + config.serverPort() + " - exiting.");
            embeddedRepl.shutdown();
            System.exit(1);
        }
        catch (Throwable e) {
            this.logger().error("Unhandled exception thrown while attempting to start server - exiting", e);
            embeddedRepl.shutdown();
            System.exit(1);
        }
    }
}

