/*
 * Decompiled with CFR 0.152.
 */
package replpp.server;

import cask.endpoints.WebsocketResult;
import cask.endpoints.WsChannelActor;
import cask.main.MainRoutes;
import cask.model.Request;
import cask.model.Response;
import cask.model.Response$;
import cask.package$;
import cask.router.Decorator;
import cask.router.RawDecorator;
import cask.router.Result;
import cask.router.RoutesEndpointsMetadata;
import cask.router.RoutesEndpointsMetadata$;
import cask.util.Ws;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import replpp.server.HasUUID;
import replpp.server.UsernamePasswordAuth;
import replpp.server.UsernamePasswordAuth$;
import replpp.server.WebServiceWithWebSocket$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.annotation.Annotation;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FileName$;
import sourcecode.Line$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Value$;

public abstract class WebServiceWithWebSocket<T extends HasUUID>
extends MainRoutes {
    private final String host;
    private final int port;
    public final Option<UsernamePasswordAuth> replpp$server$WebServiceWithWebSocket$$authenticationMaybe;
    private final Logger logger;
    public Set<WsChannelActor> replpp$server$WebServiceWithWebSocket$$openConnections;
    private final ConcurrentHashMap<UUID, Tuple2<T, Object>> resultMap;
    private final Response<Obj> unauthorizedResponse;

    public static <T extends HasUUID> Option<UsernamePasswordAuth> $lessinit$greater$default$3() {
        return WebServiceWithWebSocket$.MODULE$.$lessinit$greater$default$3();
    }

    public WebServiceWithWebSocket(String host, int port, Option<UsernamePasswordAuth> authenticationMaybe) {
        this.host = host;
        this.port = port;
        this.replpp$server$WebServiceWithWebSocket$$authenticationMaybe = authenticationMaybe;
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        this.replpp$server$WebServiceWithWebSocket$$openConnections = Predef$.MODULE$.Set().empty();
        this.resultMap = new ConcurrentHashMap();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"WWW-Authenticate");
        this.unauthorizedResponse = Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(), 401, (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"Basic"), (List)Nil$.MODULE$)), Response$.MODULE$.apply$default$4());
        WebServiceWithWebSocket Routes_this = this;
        RoutesEndpointsMetadata routesEndpointsMetadata = RoutesEndpointsMetadata$.MODULE$.apply((Seq)scala.package$.MODULE$.Nil());
        Routes_this.cask$main$Routes$$inline$metadata0_$eq(routesEndpointsMetadata);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Logger logger() {
        return this.logger;
    }

    public Response<Obj> unauthorizedResponse() {
        return this.unauthorizedResponse;
    }

    public WebsocketResult handler() {
        return package$.MODULE$.WsHandler().apply((Function1 & Serializable)connection -> {
            package$.MODULE$.Ws();
            connection.send((Object)Ws.Text$.MODULE$.apply("connected"), FileName$.MODULE$.apply("WebServiceWithWebSocket.scala"), Line$.MODULE$.apply(61));
            this.replpp$server$WebServiceWithWebSocket$$openConnections = (Set)this.replpp$server$WebServiceWithWebSocket$$openConnections.$plus(connection);
            return package$.MODULE$.WsActor().apply((PartialFunction)new Serializable((WsChannelActor)connection, this){
                private final WsChannelActor connection$1;
                private final /* synthetic */ WebServiceWithWebSocket $outer;
                {
                    this.connection$1 = connection$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Ws.Event x) {
                    block6: {
                        block5: {
                            Ws.Event event;
                            block4: {
                                event = x;
                                if (event instanceof Ws.Error) {
                                    Throwable throwable;
                                    package$.MODULE$.Ws();
                                    Ws.Error error = Ws.Error$.MODULE$.unapply((Ws.Error)event);
                                    Throwable e = throwable = error._1();
                                    return true;
                                }
                                if (!(event instanceof Ws.Close)) break block4;
                                package$.MODULE$.Ws();
                                Ws.Close close = Ws.Close$.MODULE$.unapply((Ws.Close)event);
                                int n = close._1();
                                String string = close._2();
                                break block5;
                            }
                            if (!(event instanceof Ws.ChannelClosed)) break block6;
                            package$.MODULE$.Ws();
                            if (!Ws.ChannelClosed$.MODULE$.unapply((Ws.ChannelClosed)event)) break block6;
                        }
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Ws.Event x, Function1 function1) {
                    block6: {
                        block5: {
                            Ws.Event event;
                            block4: {
                                event = x;
                                if (event instanceof Ws.Error) {
                                    Throwable throwable;
                                    package$.MODULE$.Ws();
                                    Ws.Error error = Ws.Error$.MODULE$.unapply((Ws.Error)event);
                                    Throwable e = throwable = error._1();
                                    this.$outer.logger().error("Connection error", e);
                                    this.$outer.replpp$server$WebServiceWithWebSocket$$openConnections = (Set)this.$outer.replpp$server$WebServiceWithWebSocket$$openConnections.$minus((Object)this.connection$1);
                                    return BoxedUnit.UNIT;
                                }
                                if (!(event instanceof Ws.Close)) break block4;
                                package$.MODULE$.Ws();
                                Ws.Close close = Ws.Close$.MODULE$.unapply((Ws.Close)event);
                                int n = close._1();
                                String string = close._2();
                                break block5;
                            }
                            if (!(event instanceof Ws.ChannelClosed)) break block6;
                            package$.MODULE$.Ws();
                            if (!Ws.ChannelClosed$.MODULE$.unapply((Ws.ChannelClosed)event)) break block6;
                        }
                        this.$outer.logger().debug("Connection closed.");
                        this.$outer.replpp$server$WebServiceWithWebSocket$$openConnections = (Set)this.$outer.replpp$server$WebServiceWithWebSocket$$openConnections.$minus((Object)this.connection$1);
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            }, this.actorContext(), this.log());
        }, this.actorContext(), this.log());
    }

    public Response<Obj> getResult(String uuidParam, boolean isAuthorized) {
        if (!isAuthorized) {
            return this.unauthorizedResponse();
        }
        Try try_ = Try$.MODULE$.apply(() -> WebServiceWithWebSocket.getResult$$anonfun$1(uuidParam));
        if (try_ instanceof Success) {
            UUID uUID = (UUID)((Success)try_).value();
            UUID uuid = uUID;
            if (!this.resultMap.containsKey(uuid)) {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
                Object[] objectArray = new Tuple2[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"err");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Value$.MODULE$.JsonableString((CharSequence)"No result (yet?) found for specified UUID"));
                return Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i))), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
            }
            UUID uuid2 = uUID;
            Tuple2<T, Object> tuple2 = this.resultMap.remove(uuid2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HasUUID result = (HasUUID)tuple2._1();
            boolean success = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)result, (Object)BoxesRunTime.boxToBoolean((boolean)success));
            HasUUID result2 = (HasUUID)tuple22._1();
            boolean success2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            return Response$.MODULE$.apply((Object)this.resultToJson(result2, success2), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
        }
        if (try_ instanceof Failure) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
            Object[] objectArray = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"err");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Value$.MODULE$.JsonableString((CharSequence)"UUID parameter is incorrectly formatted"));
            return Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i))), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
        }
        throw new MatchError((Object)try_);
    }

    public void returnResult(T result) {
        this.resultMap.put(result.uuid(), Tuple2$.MODULE$.apply(result, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
        this.replpp$server$WebServiceWithWebSocket$$openConnections.foreach((Function1)(JProcedure1 & Serializable)connection -> {
            package$.MODULE$.Ws();
            connection.send((Object)Ws.Text$.MODULE$.apply(result.uuid().toString()), FileName$.MODULE$.apply("WebServiceWithWebSocket.scala"), Line$.MODULE$.apply(93));
        });
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"success");
        Object[] objectArray = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"uuid");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Value$.MODULE$.JsonableString((CharSequence)result.uuid().toString()));
        Response$.MODULE$.apply((Object)Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), (Function1 & Serializable)i -> Value$.MODULE$.JsonableBoolean(BoxesRunTime.unboxToBoolean((Object)i))), 200, Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4());
    }

    public abstract Obj resultToJson(T var1, boolean var2);

    public static final Option replpp$server$WebServiceWithWebSocket$basicAuth$$_$parseAuthentication$$anonfun$1(Request request$1) {
        Object object;
        String authHeader = request$1.exchange().getRequestHeaders().get("authorization").getFirst();
        String strippedHeader = authHeader.replaceFirst("Basic ", "");
        String authString = new String(Base64.getDecoder().decode(strippedHeader));
        String[] stringArray = authString.split(":", 2);
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String username = string;
            String password = string2;
            return Some$.MODULE$.apply((Object)UsernamePasswordAuth$.MODULE$.apply(username, password));
        }
        return None$.MODULE$;
    }

    private static final UUID getResult$$anonfun$1(String uuidParam$1) {
        return UUID.fromString(uuidParam$1);
    }

    public class basicAuth
    extends Annotation
    implements Decorator,
    RawDecorator {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(basicAuth.class.getDeclaredField("utf8$lzy1"));
        private volatile Object utf8$lzy1;

        public basicAuth() {
            if (WebServiceWithWebSocket.this == null) {
                throw new NullPointerException();
            }
        }

        private Charset utf8() {
            Object object = this.utf8$lzy1;
            if (object instanceof Charset) {
                return (Charset)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Charset)this.utf8$lzyINIT1();
        }

        private Object utf8$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.utf8$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Charset charset = null;
                        try {
                            charset = StandardCharsets.UTF_8;
                            object2 = charset == null ? LazyVals.NullValue$.MODULE$ : charset;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.utf8$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return charset;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Result<Response<Response.Data>> wrapFunction(Request request, Function1<Map<String, Object>, Result<Response<Response.Data>>> delegate) {
            boolean bl;
            Option<UsernamePasswordAuth> option = WebServiceWithWebSocket.this.replpp$server$WebServiceWithWebSocket$$authenticationMaybe;
            if (None$.MODULE$.equals(option)) {
                bl = true;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                UsernamePasswordAuth requiredAuth = (UsernamePasswordAuth)((Some)option).value();
                Option<UsernamePasswordAuth> option2 = this.parseAuthentication(request);
                if (None$.MODULE$.equals(option2)) {
                    bl = false;
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError(option2);
                    UsernamePasswordAuth providedAuth = (UsernamePasswordAuth)((Some)option2).value();
                    bl = this.areEqual(providedAuth, requiredAuth);
                }
            }
            boolean isAuthorized = bl;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"isAuthorized");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)isAuthorized));
            return (Result)delegate.apply(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }

        private Option<UsernamePasswordAuth> parseAuthentication(Request request) {
            return Try$.MODULE$.apply(() -> WebServiceWithWebSocket.replpp$server$WebServiceWithWebSocket$basicAuth$$_$parseAuthentication$$anonfun$1(request)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        private boolean areEqual(UsernamePasswordAuth providedAuth, UsernamePasswordAuth expectedAuth) {
            return MessageDigest.isEqual(providedAuth.toString().getBytes(this.utf8()), expectedAuth.toString().getBytes(this.utf8()));
        }

        public final /* synthetic */ WebServiceWithWebSocket replpp$server$WebServiceWithWebSocket$basicAuth$$$outer() {
            return WebServiceWithWebSocket.this;
        }
    }
}

