/*
 * Decompiled with CFR 0.152.
 */
package replpp.shaded.os;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import replpp.shaded.geny.Generator;
import replpp.shaded.geny.Writable;
import replpp.shaded.os.Internals$;
import replpp.shaded.os.Source$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface Source
extends Writable {
    public static ChannelSource ChannelSource(SeekableByteChannel seekableByteChannel) {
        return Source$.MODULE$.ChannelSource(seekableByteChannel);
    }

    public static <T> Source WritableGenerator(Generator<T> generator, Function1<T, Writable> function1) {
        return Source$.MODULE$.WritableGenerator((Generator)generator, (Function1)function1);
    }

    public static <T> WritableSource<T> WritableSource(T t, Function1<T, Writable> function1) {
        return Source$.MODULE$.WritableSource(t, function1);
    }

    public static <M, T> Source WritableTraversable(Object object, Function1<T, Writable> function1, Function1<Object, IterableOnce<T>> function12) {
        return Source$.MODULE$.WritableTraversable(object, (Function1)function1, (Function1)function12);
    }

    public static Option httpContentType$(Source $this) {
        return $this.httpContentType();
    }

    @Override
    default public Option<String> httpContentType() {
        return Some$.MODULE$.apply((Object)"application/octet-stream");
    }

    public Either<Writable, SeekableByteChannel> getHandle();

    public static void writeBytesTo$(Source $this, OutputStream out) {
        $this.writeBytesTo(out);
    }

    @Override
    default public void writeBytesTo(OutputStream out) {
        Either<Writable, SeekableByteChannel> either = this.getHandle();
        if (either instanceof Left) {
            Writable bs = (Writable)((Left)either).value();
            bs.writeBytesTo(out);
            return;
        }
        if (either instanceof Right) {
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)((Right)either).value();
            if (seekableByteChannel instanceof FileChannel) {
                FileChannel channel = (FileChannel)seekableByteChannel;
                WritableByteChannel outChannel = Channels.newChannel(out);
                channel.transferTo(0L, Long.MAX_VALUE, outChannel);
                return;
            }
            SeekableByteChannel channel = seekableByteChannel;
            InputStream inChannel = Channels.newInputStream(channel);
            Internals$.MODULE$.transfer(inChannel, out);
            return;
        }
        throw new MatchError(either);
    }

    public static Object writeBytesTo$(Source $this, WritableByteChannel out) {
        return $this.writeBytesTo(out);
    }

    default public Object writeBytesTo(WritableByteChannel out) {
        Either<Writable, SeekableByteChannel> either = this.getHandle();
        if (either instanceof Left) {
            Writable bs = (Writable)((Left)either).value();
            BufferedOutputStream os = new BufferedOutputStream(Channels.newOutputStream(out));
            bs.writeBytesTo(os);
            os.flush();
            return BoxedUnit.UNIT;
        }
        if (either instanceof Right) {
            SeekableByteChannel channel = (SeekableByteChannel)((Right)either).value();
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)channel, (Object)out);
            if (tuple2 != null) {
                SeekableByteChannel seekableByteChannel = (SeekableByteChannel)tuple2._1();
                WritableByteChannel writableByteChannel = (WritableByteChannel)tuple2._2();
                if (seekableByteChannel instanceof FileChannel) {
                    FileChannel src = (FileChannel)seekableByteChannel;
                    WritableByteChannel dest = writableByteChannel;
                    long size = src.size();
                    for (long pos = 0L; pos < size; pos += src.transferTo(pos, size - pos, dest)) {
                    }
                    return BoxedUnit.UNIT;
                }
                SeekableByteChannel src = seekableByteChannel;
                if (writableByteChannel instanceof FileChannel) {
                    FileChannel dest = (FileChannel)writableByteChannel;
                    return BoxesRunTime.boxToLong((long)dest.transferFrom(src, 0L, Long.MAX_VALUE));
                }
                SeekableByteChannel src2 = seekableByteChannel;
                WritableByteChannel dest = writableByteChannel;
                BufferedOutputStream os = new BufferedOutputStream(Channels.newOutputStream(dest));
                Internals$.MODULE$.transfer(Channels.newInputStream(src2), os);
                os.flush();
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(either);
    }

    public static class ChannelSource
    implements Writable,
    Source {
        private final SeekableByteChannel cn;

        public ChannelSource(SeekableByteChannel cn) {
            this.cn = cn;
        }

        @Override
        public Either<Writable, SeekableByteChannel> getHandle() {
            return package$.MODULE$.Right().apply((Object)this.cn);
        }
    }

    public static class WritableSource<T>
    implements Source {
        private final Writable writable;

        public WritableSource(T s, Function1<T, Writable> f) {
            this.writable = (Writable)f.apply(s);
        }

        public Writable writable() {
            return this.writable;
        }

        @Override
        public Either<Writable, SeekableByteChannel> getHandle() {
            return package$.MODULE$.Left().apply((Object)this.writable());
        }
    }
}

