/*
 * Decompiled with CFR 0.152.
 */
package replpp.shaded.os;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import replpp.shaded.os.BasePath;
import replpp.shaded.os.BasePathImpl;
import replpp.shaded.os.FilePath;
import replpp.shaded.os.Internals$;
import replpp.shaded.os.Path$;
import replpp.shaded.os.PathChunk;
import replpp.shaded.os.PathConvertible;
import replpp.shaded.os.PathError$AbsolutePathOutsideRoot$;
import replpp.shaded.os.ReadablePath;
import replpp.shaded.os.RelPath;
import replpp.shaded.os.SeekableSource;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public class Path
implements BasePath,
FilePath,
ReadablePath,
BasePathImpl {
    private final java.nio.file.Path wrapped;

    public static Path apply(FilePath filePath, Path path) {
        return Path$.MODULE$.apply(filePath, path);
    }

    public static <T> Path apply(T t, Path path, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.apply(t, path, pathConvertible);
    }

    public static <T> Path apply(T t, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.apply(t, pathConvertible);
    }

    public static <T> Path expandUser(T t, Path path, PathConvertible<T> pathConvertible) {
        return Path$.MODULE$.expandUser(t, path, pathConvertible);
    }

    public static Ordering<Path> pathOrdering() {
        return Path$.MODULE$.pathOrdering();
    }

    public static <T> Path expandUser$default$2() {
        return Path$.MODULE$.expandUser$default$2();
    }

    public Path(java.nio.file.Path wrapped) {
        this.wrapped = wrapped;
        Predef$.MODULE$.require(wrapped.isAbsolute(), () -> Path.$init$$$anonfun$4(wrapped));
    }

    public java.nio.file.Path wrapped() {
        return this.wrapped;
    }

    @Override
    public SeekableSource toSource() {
        return new SeekableSource.ChannelSource(Files.newByteChannel(this.wrapped(), new OpenOption[0]));
    }

    public Iterator<String> segments() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.wrapped().iterator()).asScala()).map((Function1 & Serializable)_$6 -> _$6.toString());
    }

    public String getSegment(int i) {
        return this.wrapped().getName(i).toString();
    }

    public int segmentCount() {
        return this.wrapped().getNameCount();
    }

    @Override
    public Option<String> lastOpt() {
        return Option$.MODULE$.apply((Object)this.wrapped().getFileName()).map((Function1 & Serializable)_$7 -> _$7.toString());
    }

    @Override
    public Path $div(PathChunk chunk) {
        if (chunk.ups() > this.wrapped().getNameCount()) {
            throw PathError$AbsolutePathOutsideRoot$.MODULE$;
        }
        java.nio.file.Path resolved = this.wrapped().resolve(chunk.toString()).normalize();
        return new Path(resolved);
    }

    public String toString() {
        return this.wrapped().toString();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Path) {
            Path p = (Path)object;
            return this.wrapped().equals(p.wrapped());
        }
        return false;
    }

    public int hashCode() {
        return this.wrapped().hashCode();
    }

    public boolean startsWith(Path target) {
        return this.wrapped().startsWith(target.wrapped());
    }

    @Override
    public boolean endsWith(RelPath target) {
        return this.wrapped().endsWith(target.toString());
    }

    public RelPath relativeTo(Path base) {
        int n;
        Object[] arr;
        String string;
        Object object;
        java.nio.file.Path nioRel = base.wrapped().relativize(this.wrapped());
        Object[] objectArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(nioRel.iterator()).asScala()).map((Function1 & Serializable)_$8 -> _$8.toString()).toArray(ClassTag$.MODULE$.apply(String.class));
        Object[] segments = objectArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)objectArray), 1) == 0 && "".equals(string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0)) ? Internals$.MODULE$.emptyStringArray() : (arr = objectArray);
        Object object2 = Predef$.MODULE$.refArrayOps(segments);
        int n2 = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)_$9 -> {
            String string = _$9;
            String string2 = "..";
            return string == null ? string2 != null : !string.equals(string2);
        }, ArrayOps$.MODULE$.indexWhere$default$2$extension(object2));
        int nonUpIndex = -1 == n2 ? segments.length : (n = n2);
        Object object3 = Predef$.MODULE$.refArrayOps(segments);
        return new RelPath((String[])ArrayOps$.MODULE$.drop$extension(object3, nonUpIndex), nonUpIndex);
    }

    public File toIO() {
        return this.wrapped().toFile();
    }

    @Override
    public java.nio.file.Path toNIO() {
        return this.wrapped();
    }

    @Override
    public Path resolveFrom(Path base) {
        return this;
    }

    @Override
    public InputStream getInputStream() {
        return Files.newInputStream(this.wrapped(), new OpenOption[0]);
    }

    private static final Object $init$$$anonfun$4(java.nio.file.Path wrapped$1) {
        return wrapped$1 + " is not an absolute path";
    }
}

