/*
 * Decompiled with CFR 0.152.
 */
package replpp.shaded.geny;

import java.io.Serializable;
import replpp.shaded.geny.Generator$;
import replpp.shaded.geny.Generator$Continue$;
import replpp.shaded.geny.Generator$End$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public interface Generator<A> {
    public static <T> Generator<T> apply(Seq<T> seq) {
        return Generator$.MODULE$.apply(seq);
    }

    public static <M, T> Generator<T> from(Object object, Function1<Object, IterableOnce<T>> function1) {
        return Generator$.MODULE$.from(object, function1);
    }

    public static <T> Generator<T> selfClosing(Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> function0) {
        return Generator$.MODULE$.selfClosing(function0);
    }

    public Action generate(Function1<A, Action> var1);

    public static void foreach$(Generator $this, Function1 f) {
        $this.foreach(f);
    }

    default public void foreach(Function1<A, BoxedUnit> f) {
        this.generate((Function1 & Serializable)x -> {
            f.apply(x);
            return Generator$Continue$.MODULE$;
        });
    }

    public static Option find$(Generator $this, Function1 f) {
        return $this.find(f);
    }

    default public Option<A> find(Function1<A, Object> f) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.generate((Function1 & Serializable)t -> {
            if (!BoxesRunTime.unboxToBoolean((Object)f.apply(t))) {
                return Generator$Continue$.MODULE$;
            }
            result$1.elem = Some$.MODULE$.apply(t);
            return Generator$End$.MODULE$;
        });
        return (Option)result.elem;
    }

    public static boolean exists$(Generator $this, Function1 f) {
        return $this.exists(f);
    }

    default public boolean exists(Function1<A, Object> f) {
        return this.find(f).isDefined();
    }

    public static boolean contains$(Generator $this, Object a) {
        return $this.contains(a);
    }

    default public boolean contains(Object a) {
        return this.exists((Function1 & Serializable)_$2 -> BoxesRunTime.equals((Object)_$2, (Object)a));
    }

    public static boolean forall$(Generator $this, Function1 f) {
        return $this.forall(f);
    }

    default public boolean forall(Function1<A, Object> f) {
        return !this.exists((Function1 & Serializable)_$3 -> !BoxesRunTime.unboxToBoolean((Object)f.apply(_$3)));
    }

    public static int count$(Generator $this, Function1 f) {
        return $this.count(f);
    }

    default public int count(Function1<A, Object> f) {
        IntRef result = IntRef.create((int)0);
        this.generate((Function1 & Serializable)t -> {
            if (BoxesRunTime.unboxToBoolean((Object)f.apply(t))) {
                ++result$2.elem;
            }
            return Generator$Continue$.MODULE$;
        });
        return result.elem;
    }

    public static Function1 count$default$1$(Generator $this) {
        return $this.count$default$1();
    }

    default public Function1<A, Object> count$default$1() {
        return (Function1 & Serializable)_$4 -> true;
    }

    public static Object fold$(Generator $this, Object start, Function2 f) {
        return $this.fold(start, f);
    }

    default public <B> B fold(B start, Function2<B, A, B> f) {
        return this.foldLeft(start, f);
    }

    public static Object foldLeft$(Generator $this, Object start, Function2 f) {
        return $this.foldLeft(start, f);
    }

    default public <B> B foldLeft(B start, Function2<B, A, B> f) {
        ObjectRef result = ObjectRef.create(start);
        this.generate((Function1 & Serializable)t -> {
            result$3.elem = f.apply(result$3.elem, t);
            return Generator$Continue$.MODULE$;
        });
        return (B)result.elem;
    }

    public static Object reduce$(Generator $this, Function2 f) {
        return $this.reduce(f);
    }

    default public <B> B reduce(Function2<B, A, B> f) {
        return this.reduceLeft(f);
    }

    public static Object reduceLeft$(Generator $this, Function2 f) {
        return $this.reduceLeft(f);
    }

    default public <B> B reduceLeft(Function2<B, A, B> f) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.generate((Function1 & Serializable)t -> {
            Some some;
            Option option = (Option)result$4.elem;
            if (None$.MODULE$.equals(option)) {
                some = Some$.MODULE$.apply(t);
            } else if (option instanceof Some) {
                Object old = ((Some)option).value();
                some = Some$.MODULE$.apply(f.apply(old, t));
            } else {
                throw new MatchError((Object)option);
            }
            result$4.elem = some;
            return Generator$Continue$.MODULE$;
        });
        return (B)((Option)result.elem).getOrElse(Generator::reduceLeft$$anonfun$2);
    }

    public static Generator filter$(Generator $this, Function1 pred) {
        return $this.filter(pred);
    }

    default public Generator<A> filter(Function1<A, Object> pred) {
        return new Filtered<A>(this, pred);
    }

    public static Generator withFilter$(Generator $this, Function1 pred) {
        return $this.withFilter(pred);
    }

    default public Generator<A> withFilter(Function1<A, Object> pred) {
        return new Filtered<A>(this, pred);
    }

    public static Generator map$(Generator $this, Function1 func) {
        return $this.map(func);
    }

    default public <B> Generator<B> map(Function1<A, B> func) {
        return new Mapped<B, A>(this, func);
    }

    public static Generator flatMap$(Generator $this, Function1 func) {
        return $this.flatMap(func);
    }

    default public <B> Generator<B> flatMap(Function1<A, Generator<B>> func) {
        return new FlatMapped<B, A>(this, func);
    }

    public static Generator collect$(Generator $this, PartialFunction func) {
        return $this.collect(func);
    }

    default public <B> Generator<B> collect(PartialFunction<A, B> func) {
        return this.filter((Function1 & Serializable)x -> func.isDefinedAt(x)).map((Function1<A, B>)func);
    }

    public static Option collectFirst$(Generator $this, PartialFunction func) {
        return $this.collectFirst(func);
    }

    default public <B> Option<B> collectFirst(PartialFunction<A, B> func) {
        return this.filter((Function1 & Serializable)x -> func.isDefinedAt(x)).map((Function1<A, B>)func).headOption();
    }

    public static Generator flatten$(Generator $this, Function1 f) {
        return $this.flatten(f);
    }

    default public <V> Generator<V> flatten(Function1<A, Generator<V>> f) {
        return this.flatMap(f);
    }

    public static Generator slice$(Generator $this, int start, int end) {
        return $this.slice(start, end);
    }

    default public Generator<A> slice(int start, int end) {
        return new Sliced(this, start, end);
    }

    public static Generator take$(Generator $this, int n) {
        return $this.take(n);
    }

    default public Generator<A> take(int n) {
        return this.slice(0, n);
    }

    public static Generator drop$(Generator $this, int n) {
        return $this.drop(n);
    }

    default public Generator<A> drop(int n) {
        return this.slice(n, Integer.MAX_VALUE);
    }

    public static Generator takeWhile$(Generator $this, Function1 pred) {
        return $this.takeWhile(pred);
    }

    default public Generator<A> takeWhile(Function1<A, Object> pred) {
        return new TakeWhile<A>(this, pred);
    }

    public static Generator dropWhile$(Generator $this, Function1 pred) {
        return $this.dropWhile(pred);
    }

    default public Generator<A> dropWhile(Function1<A, Object> pred) {
        return new DropWhile<A>(this, pred);
    }

    public static Generator zipWithIndex$(Generator $this) {
        return $this.zipWithIndex();
    }

    default public Generator<Tuple2<A, Object>> zipWithIndex() {
        return new ZipWithIndexed(this);
    }

    public static Generator zip$(Generator $this, Iterable other) {
        return $this.zip(other);
    }

    default public <B> Generator<Tuple2<A, B>> zip(Iterable<B> other) {
        return new Zipped(this, other);
    }

    public static Generator $plus$plus$(Generator $this, Generator other) {
        return $this.$plus$plus(other);
    }

    default public <B> Generator<B> $plus$plus(Generator<B> other) {
        return new Concat<B>(this, other);
    }

    public static Object head$(Generator $this) {
        return $this.head();
    }

    default public A head() {
        return (A)this.take(1).toSeq().head();
    }

    public static Option headOption$(Generator $this) {
        return $this.headOption();
    }

    default public Option<A> headOption() {
        return this.take(1).toSeq().headOption();
    }

    public static Buffer toBuffer$(Generator $this) {
        return $this.toBuffer();
    }

    default public <B> Buffer<B> toBuffer() {
        Buffer arr = (Buffer)Buffer$.MODULE$.empty();
        this.foreach((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> arr.append(_$5));
        return arr;
    }

    public static Object toArray$(Generator $this, ClassTag evidence$1) {
        return $this.toArray(evidence$1);
    }

    default public <B> Object toArray(ClassTag<B> evidence$1) {
        return this.toBuffer().toArray(evidence$1);
    }

    public static Seq toSeq$(Generator $this) {
        return $this.toSeq();
    }

    default public Seq<A> toSeq() {
        return this.toVector();
    }

    public static List toList$(Generator $this) {
        return $this.toList();
    }

    default public List<A> toList() {
        return this.toBuffer().toList();
    }

    public static Set toSet$(Generator $this) {
        return $this.toSet();
    }

    default public <B> Set<B> toSet() {
        return this.toBuffer().toSet();
    }

    public static Vector toVector$(Generator $this) {
        return $this.toVector();
    }

    default public Vector<A> toVector() {
        return this.toBuffer().toVector();
    }

    public static String mkString$(Generator $this, String start, String sep, String end) {
        return $this.mkString(start, sep, end);
    }

    default public String mkString(String start, String sep, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreach((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)x -> {
            if (!first$1.elem) {
                sb.append(sep);
            }
            sb.append(x);
            first$1.elem = false;
        });
        sb.append(end);
        return sb.toString();
    }

    public static String mkString$(Generator $this, String sep) {
        return $this.mkString(sep);
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public static String mkString$(Generator $this) {
        return $this.mkString();
    }

    default public String mkString() {
        return this.mkString("");
    }

    public static Object sum$(Generator $this, Numeric num) {
        return $this.sum(num);
    }

    default public <B> B sum(Numeric<B> num) {
        return (B)this.foldLeft(num.zero(), (Function2 & Serializable)(x, y) -> num.plus(x, y));
    }

    public static Object product$(Generator $this, Numeric num) {
        return $this.product(num);
    }

    default public <B> B product(Numeric<B> num) {
        return (B)this.foldLeft(num.one(), (Function2 & Serializable)(x, y) -> num.times(x, y));
    }

    public static Object min$(Generator $this, Ordering cmp) {
        return $this.min(cmp);
    }

    default public <B> A min(Ordering<B> cmp) {
        return (A)this.reduceLeft((Function2 & Serializable)(x, y) -> {
            if (cmp.lteq(x, y)) {
                return x;
            }
            return y;
        });
    }

    public static Object max$(Generator $this, Ordering cmp) {
        return $this.max(cmp);
    }

    default public <B> A max(Ordering<B> cmp) {
        return (A)this.reduceLeft((Function2 & Serializable)(x, y) -> {
            if (cmp.gteq(x, y)) {
                return x;
            }
            return y;
        });
    }

    public static Object maxBy$(Generator $this, Function1 f, Ordering cmp) {
        return $this.maxBy(f, cmp);
    }

    default public <B> A maxBy(Function1<A, B> f, Ordering<B> cmp) {
        ObjectRef maxF = ObjectRef.create(null);
        ObjectRef maxElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreach((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)elem -> {
            Object fx = f.apply(elem);
            if (first$2.elem || cmp.gt(fx, maxF$1.elem)) {
                maxElem$1.elem = elem;
                maxF$1.elem = fx;
                first$2.elem = false;
                return;
            }
        });
        return (A)maxElem.elem;
    }

    public static Object minBy$(Generator $this, Function1 f, Ordering cmp) {
        return $this.minBy(f, cmp);
    }

    default public <B> A minBy(Function1<A, B> f, Ordering<B> cmp) {
        ObjectRef minF = ObjectRef.create(null);
        ObjectRef minElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create((boolean)true);
        this.foreach((Function1<A, BoxedUnit>)(JProcedure1 & Serializable)elem -> {
            Object fx = f.apply(elem);
            if (first$3.elem || cmp.lt(fx, minF$1.elem)) {
                minElem$1.elem = elem;
                minF$1.elem = fx;
                first$3.elem = false;
                return;
            }
        });
        return (A)minElem.elem;
    }

    private static Object reduceLeft$$anonfun$2() {
        throw new UnsupportedOperationException("empty.reduceLeft");
    }

    public static interface Action {
    }

    public static class Concat<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Generator<T> other;

        public Concat(Generator<T> inner, Generator<T> other) {
            this.inner = inner;
            this.other = other;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            Action res1;
            Action action = res1 = this.inner.generate(f);
            Generator$End$ generator$End$ = Generator$End$.MODULE$;
            if (!(action != null ? !action.equals(generator$End$) : generator$End$ != null)) {
                return Generator$End$.MODULE$;
            }
            return this.other.generate(f);
        }

        public String toString() {
            return this.inner + " ++ " + this.other;
        }
    }

    public static class DropWhile<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public DropWhile(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            BooleanRef started = BooleanRef.create((boolean)false);
            return this.inner.generate((Function1 & Serializable)t -> {
                if (!started$1.elem) {
                    if (BoxesRunTime.unboxToBoolean((Object)this.pred.apply(t))) {
                        return Generator$Continue$.MODULE$;
                    }
                    started$1.elem = true;
                    return (Action)f.apply(t);
                }
                return (Action)f.apply(t);
            });
        }

        public String toString() {
            return this.inner + ".dropWhile(" + this.pred + ")";
        }
    }

    public static class Filtered<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public Filtered(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1 & Serializable)t -> {
                if (BoxesRunTime.unboxToBoolean((Object)this.pred.apply(t))) {
                    return (Action)f.apply(t);
                }
                return Generator$Continue$.MODULE$;
            });
        }

        public String toString() {
            return this.inner + ".filter(" + this.pred + ")";
        }
    }

    public static class FlatMapped<T, V>
    implements Generator<T> {
        private final Generator<V> inner;
        private final Function1<V, Generator<T>> func;

        public FlatMapped(Generator<V> inner, Function1<V, Generator<T>> func) {
            this.inner = inner;
            this.func = func;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1 & Serializable)outerT -> ((Generator)this.func.apply(outerT)).generate(arg_0 -> Generator$.replpp$shaded$geny$Generator$FlatMapped$$_$generate$$anonfun$5$$anonfun$1(f, arg_0)));
        }

        public String toString() {
            return this.inner + ".map(" + this.func + ")";
        }
    }

    public static class Mapped<T, V>
    implements Generator<T> {
        private final Generator<V> inner;
        private final Function1<V, T> func;

        public Mapped(Generator<V> inner, Function1<V, T> func) {
            this.inner = inner;
            this.func = func;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1 & Serializable)t -> (Action)f.apply(this.func.apply(t)));
        }

        public String toString() {
            return this.inner + ".map(" + this.func + ")";
        }
    }

    public static class SelfClosing<T>
    implements Generator<T> {
        private final Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> makeIterator;

        public SelfClosing(Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> makeIterator) {
            this.makeIterator = makeIterator;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            Generator$Continue$ generator$Continue$;
            Action last = Generator$Continue$.MODULE$;
            Tuple2 tuple2 = (Tuple2)this.makeIterator.apply();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterator iterator = (Iterator)tuple2._1();
            Function0 onComplete = (Function0)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)iterator, (Object)onComplete);
            Iterator iterator2 = (Iterator)tuple22._1();
            Function0 onComplete2 = (Function0)tuple22._2();
            try {
                while (true) {
                    Generator$Continue$ generator$Continue$2 = last;
                    Generator$Continue$ generator$Continue$3 = Generator$Continue$.MODULE$;
                    if ((generator$Continue$2 != null ? !generator$Continue$2.equals(generator$Continue$3) : generator$Continue$3 != null) || !iterator2.hasNext()) break;
                    last = (Action)f.apply(iterator2.next());
                }
                generator$Continue$ = last;
            }
            finally {
                onComplete2.apply$mcV$sp();
            }
            return generator$Continue$;
        }

        public String toString() {
            return "Gen.SelfClosing(...)";
        }
    }

    public static class Sliced<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final int start;
        private final int end;

        public Sliced(Generator<T> inner, int start, int end) {
            this.inner = inner;
            this.start = start;
            this.end = end;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            IntRef count = IntRef.create((int)0);
            return this.inner.generate((Function1 & Serializable)t -> {
                if (count$1.elem < this.start) {
                    ++count$1.elem;
                    return Generator$Continue$.MODULE$;
                }
                if (count$1.elem < this.end) {
                    ++count$1.elem;
                    if (count$1.elem != this.end) {
                        return (Action)f.apply(t);
                    }
                    f.apply(t);
                    return Generator$End$.MODULE$;
                }
                return Generator$End$.MODULE$;
            });
        }

        public String toString() {
            return this.inner + ".slice(" + this.start + ", " + this.end + ")";
        }
    }

    public static class TakeWhile<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public TakeWhile(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1 & Serializable)t -> {
                if (BoxesRunTime.unboxToBoolean((Object)this.pred.apply(t))) {
                    return (Action)f.apply(t);
                }
                return Generator$End$.MODULE$;
            });
        }

        public String toString() {
            return this.inner + ".takeWhile(" + this.pred + ")";
        }
    }

    public static class ZipWithIndexed<T>
    implements Generator<Tuple2<T, Object>> {
        private final Generator<T> inner;

        public ZipWithIndexed(Generator<T> inner) {
            this.inner = inner;
        }

        @Override
        public Action generate(Function1<Tuple2<T, Object>, Action> f) {
            IntRef i = IntRef.create((int)0);
            return this.inner.generate(arg_0 -> Generator$.replpp$shaded$geny$Generator$ZipWithIndexed$$_$generate$$anonfun$1(f, i, arg_0));
        }

        public String toString() {
            return this.inner + ".zipWithIndex";
        }
    }

    public static class Zipped<T, V>
    implements Generator<Tuple2<T, V>> {
        private final Generator<T> inner;
        private final Iterable<V> other;

        public Zipped(Generator<T> inner, Iterable<V> other) {
            this.inner = inner;
            this.other = other;
        }

        @Override
        public Action generate(Function1<Tuple2<T, V>, Action> f) {
            Iterator iter = this.other.iterator();
            return this.inner.generate(arg_0 -> Generator$.replpp$shaded$geny$Generator$Zipped$$_$generate$$anonfun$2(iter, f, arg_0));
        }

        public String toString() {
            return this.inner + ".zip(" + this.other + ")";
        }
    }
}

