/*
 * Decompiled with CFR 0.152.
 */
package replpp.scripting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.io.ClassPath$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import replpp.scripting.CompilerError$;
import replpp.scripting.ScriptingDriver$;
import replpp.scripting.WrapForMainArgs;
import replpp.scripting.WrapForMainArgs$;
import replpp.util.SimpleDriver;
import replpp.util.package$;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Try;

public class ScriptingDriver {
    private final String[] compilerArgs;
    private final Seq<Path> predefFiles;
    private final String[] scriptArgs;
    public final boolean replpp$scripting$ScriptingDriver$$verbose;
    private final WrapForMainArgs.WrappingResult wrappingResult;
    private final Path wrappedScript;
    private final Builder<Path, Seq<Path>> tempFiles;
    private boolean executed;

    public static String MainClassName() {
        return ScriptingDriver$.MODULE$.MainClassName();
    }

    public static String MainMethodName() {
        return ScriptingDriver$.MODULE$.MainMethodName();
    }

    public ScriptingDriver(String[] compilerArgs, Seq<Path> predefFiles, Seq<String> runBefore, Seq<String> runAfter, Path scriptFile, String[] scriptArgs, boolean verbose) {
        this.compilerArgs = compilerArgs;
        this.predefFiles = predefFiles;
        this.scriptArgs = scriptArgs;
        this.replpp$scripting$ScriptingDriver$$verbose = verbose;
        this.wrappingResult = WrapForMainArgs$.MODULE$.apply(Files.readString(scriptFile), runBefore, runAfter);
        this.wrappedScript = Files.createTempFile("wrapped-script", ".sc", new FileAttribute[0]);
        this.tempFiles = scala.package$.MODULE$.Seq().newBuilder();
        this.executed = false;
        Files.writeString(this.wrappedScript, (CharSequence)this.wrappingResult.fullScript(), new OpenOption[0]);
        this.tempFiles.$plus$eq((Object)this.wrappedScript);
        if (verbose) {
            Predef$.MODULE$.println((Object)("predefFiles: " + predefFiles.mkString(";")));
            Predef$.MODULE$.println((Object)("full script content (including wrapper code) (" + this.wrappedScript + ")"));
            Predef$.MODULE$.println((Object)this.wrappingResult.fullScript());
            Predef$.MODULE$.println((Object)("script arguments: " + Predef$.MODULE$.wrapRefArray((Object[])scriptArgs).mkString(",")));
            Predef$.MODULE$.println((Object)("compiler arguments: " + Predef$.MODULE$.wrapRefArray((Object[])compilerArgs).mkString(",")));
        }
    }

    public Try<Object> compileAndRun() {
        if (this.executed) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"scripting driver can only be used once, and this instance has already been used.");
        }
        this.executed = true;
        Seq inputFiles = (Seq)((IterableOps)this.predefFiles.$plus$colon((Object)this.wrappedScript)).filter((Function1 & Serializable)_$1 -> Files.exists(_$1, new LinkOption[0]));
        SimpleDriver driver = new SimpleDriver(this.wrappingResult.linesBeforeRunBeforeCode(), this.wrappingResult.linesBeforeScript());
        Try result = driver.compile(this.compilerArgs, (Seq<Path>)inputFiles, this.replpp$scripting$ScriptingDriver$$verbose, (Function2 & Serializable)(ctx, outDir) -> {
            this.tempFiles.$plus$eq(outDir);
            String inheritedClasspath = (String)Settings.Setting$.MODULE$.value(ctx.settings().classpath(), ScriptingDriver.given_Context$1(ctx));
            List classpathEntries = ClassPath$.MODULE$.expandPath(inheritedClasspath, true).map((Function1 & Serializable)_$2 -> Paths.get(_$2, new String[0]));
            Method mainMethod = this.lookupMainMethod((Path)outDir, (Seq<Path>)classpathEntries);
            return mainMethod.invoke(null, new Object[]{this.scriptArgs});
        });
        ((IterableOnceOps)this.tempFiles.result()).foreach((Function1)(JProcedure1 & Serializable)path -> package$.MODULE$.deleteRecursively((Path)path));
        return result.recoverWith((PartialFunction)new Serializable(inputFiles, this){
            private final Seq inputFiles$1;
            private final /* synthetic */ ScriptingDriver $outer;
            {
                this.inputFiles$1 = inputFiles$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable e = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable e = throwable = x;
                String msgAddonMaybe = this.$outer.replpp$scripting$ScriptingDriver$$verbose ? "" : "Re-run with `--verbose` for more details";
                return Failure$.MODULE$.apply((Throwable)CompilerError$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Error during compilation: " + e.getMessage() + "\n           |Please check error output above!\n           |For given input files: " + this.inputFiles$1.mkString(", ") + "\n           |" + msgAddonMaybe + "\n           |"))));
            }
        });
    }

    private Method lookupMainMethod(Path outDir, Seq<Path> classpathEntries) {
        Seq classpathUrls = (Seq)((IterableOps)classpathEntries.$colon$plus((Object)outDir)).map((Function1 & Serializable)_$3 -> _$3.toUri().toURL());
        Class<?> clazz = new URLClassLoader((URL[])classpathUrls.toArray(ClassTag$.MODULE$.apply(URL.class))).loadClass(ScriptingDriver$.MODULE$.MainClassName());
        return clazz.getMethod(ScriptingDriver$.MODULE$.MainMethodName(), String[].class);
    }

    private static final Contexts.Context given_Context$1(Contexts.Context ctx$1) {
        return ctx$1;
    }
}

