/*
 * Decompiled with CFR 0.152.
 */
package replpp.scripting;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import replpp.Config;
import replpp.Config$;
import replpp.package$;
import replpp.scripting.ScriptingDriver;
import replpp.scripting.ScriptingDriver$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class NonForkingScriptRunner$
implements Serializable {
    public static final NonForkingScriptRunner$ MODULE$ = new NonForkingScriptRunner$();

    private NonForkingScriptRunner$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NonForkingScriptRunner$.class);
    }

    public void main(String[] args) {
        Config config = Config$.MODULE$.parse(args);
        this.exec(config);
    }

    public void exec(Config config) {
        Path scriptFile = (Path)config.scriptFile().getOrElse(NonForkingScriptRunner$::$anonfun$1);
        if (!Files.exists(scriptFile, new LinkOption[0])) {
            throw new AssertionError((Object)("given script file " + scriptFile + " does not exist"));
        }
        String paramsInfoMaybe = config.params().nonEmpty() ? " with params=" + config.params() : "";
        System.err.println("executing " + scriptFile + paramsInfoMaybe);
        List commandArgs = config.command().toList();
        Iterable parameterArgs = (Iterable)config.params().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return (Seq)((SeqOps)new .colon.colon((Object)("--" + key), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq scriptArgs = (Seq)commandArgs.$plus$plus((IterableOnce)parameterArgs);
        String predefCode = package$.MODULE$.allPredefCode(config);
        String scriptCode = Files.readString(scriptFile);
        String scriptContent = this.wrapForMainargs(predefCode, scriptCode);
        Path predefPlusScriptFileTmp = Files.createTempFile("scala-repl-pp-script-with-predef", ".sc", new FileAttribute[0]);
        Files.writeString(predefPlusScriptFileTmp, (CharSequence)scriptContent, new OpenOption[0]);
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.compilerArgs(config));
        String[] compilerArgs = (String[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)"-nowarn", ClassTag$.MODULE$.apply(String.class));
        boolean verboseEnabled = package$.MODULE$.verboseEnabled(config);
        Option<Throwable> option = new ScriptingDriver(compilerArgs, predefPlusScriptFileTmp, (String[])scriptArgs.toArray(ClassTag$.MODULE$.apply(String.class)), verboseEnabled).compileAndRun();
        if (option instanceof Some) {
            Throwable exception = (Throwable)((Some)option).value();
            System.err.println("error during script execution: " + exception.getMessage());
            System.err.println("note: line numbers may not be accurate - to help with debugging, the final scriptContent is at " + predefPlusScriptFileTmp);
            throw exception;
        }
        if (None$.MODULE$.equals(option)) {
            if (verboseEnabled) {
                System.err.println("script finished successfully");
            }
            Files.deleteIfExists(predefPlusScriptFileTmp);
            return;
        }
        throw new MatchError(option);
    }

    private String wrapForMainargs(String predefCode, String scriptCode) {
        String mainImpl = scriptCode.contains("@main") ? scriptCode : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("@main def _execMain(): Unit = {\n           |  " + scriptCode + "\n           |}\n           |"));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("import replpp.shaded.mainargs\n       |import mainargs.main // intentionally shadow any potentially given @main\n       |\n       |// ScriptingDriver expects an object with a predefined name and a main entrypoint method\n       |object " + ScriptingDriver$.MODULE$.MainClassName() + " {\n       |\n       |" + predefCode + "\n       |\n       |" + mainImpl + "\n       |\n       |  def " + ScriptingDriver$.MODULE$.MainMethodName() + "(args: Array[String]): Unit = {\n       |    mainargs.ParserForMethods(this).runOrExit(args.toSeq)\n       |  }\n       |}\n       |"));
    }

    private static final Path $anonfun$1() {
        throw new AssertionError((Object)"script file not defined - please specify e.g. via `--script=myscript.sc`");
    }
}

