/*
 * Decompiled with CFR 0.152.
 */
package replpp.scripting;

import dotty.tools.dotc.Driver;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.io.ClassPath$;
import dotty.tools.io.Directory$;
import dotty.tools.io.PlainDirectory;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import replpp.scripting.ScriptingDriver$;
import replpp.scripting.ScriptingException$;
import replpp.util.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public class ScriptingDriver
extends Driver {
    private final String[] compilerArgs;
    private final Path scriptFile;
    private final String[] scriptArgs;
    private final boolean verbose;

    public static String MainClassName() {
        return ScriptingDriver$.MODULE$.MainClassName();
    }

    public static String MainMethodName() {
        return ScriptingDriver$.MODULE$.MainMethodName();
    }

    public ScriptingDriver(String[] compilerArgs, Path scriptFile, String[] scriptArgs, boolean verbose) {
        this.compilerArgs = compilerArgs;
        this.scriptFile = scriptFile;
        this.scriptArgs = scriptArgs;
        this.verbose = verbose;
        if (verbose) {
            Predef$.MODULE$.println((Object)("full script content (including wrapper code) -> " + scriptFile + ":"));
            Predef$.MODULE$.println((Object)Files.readString(scriptFile));
            Predef$.MODULE$.println((Object)("script arguments: " + Predef$.MODULE$.wrapRefArray((Object[])scriptArgs).mkString(",")));
            Predef$.MODULE$.println((Object)("compiler arguments: " + Predef$.MODULE$.wrapRefArray((Object[])compilerArgs).mkString(",")));
        }
    }

    public Option<Throwable> compileAndRun() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.compilerArgs);
        return this.setup((String[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)this.scriptFile.toAbsolutePath().toString(), ClassTag$.MODULE$.apply(String.class)), (Contexts.Context)this.initCtx().fresh()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Some some;
                Path outDir;
                List toCompile = (List)tuple2._1();
                LazyRef lazyRef = new LazyRef();
                Contexts.Context rootCtx = (Contexts.Context)tuple2._2();
                if (this.doCompile(this.newCompiler(this.given_Context$1(lazyRef, rootCtx, outDir = Files.createTempDirectory("scala3-scripting", new FileAttribute[0]))), toCompile, this.given_Context$1(lazyRef, rootCtx, outDir)).hasErrors()) {
                    String msgAddonMaybe = this.verbose ? "" : " - try `--verbose` for more output";
                    return Some$.MODULE$.apply((Object)ScriptingException$.MODULE$.apply("Errors encountered during compilation" + msgAddonMaybe));
                }
                String classpath = outDir.toAbsolutePath() + File.pathSeparator + Settings.Setting$.MODULE$.value(this.given_Context$1(lazyRef, rootCtx, outDir).settings().classpath(), this.given_Context$1(lazyRef, rootCtx, outDir));
                List classpathEntries = ClassPath$.MODULE$.expandPath(classpath, true).map((Function1 & Serializable)_$1 -> Paths.get(_$1, new String[0]));
                Method mainMethod = this.lookupMainMethod(outDir, (Seq<Path>)classpathEntries);
                try {
                    try {
                        mainMethod.invoke(null, new Object[]{this.scriptArgs});
                        some = None$.MODULE$;
                    }
                    catch (InvocationTargetException e) {
                        some = Some$.MODULE$.apply((Object)e.getCause());
                    }
                }
                finally {
                    package$.MODULE$.deleteRecursively(outDir);
                }
                return some;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Method lookupMainMethod(Path outDir, Seq<Path> classpathEntries) {
        Seq classpathUrls = (Seq)((IterableOps)classpathEntries.$colon$plus((Object)outDir)).map((Function1 & Serializable)_$2 -> _$2.toUri().toURL());
        Class<?> clazz = new URLClassLoader((URL[])classpathUrls.toArray(ClassTag$.MODULE$.apply(URL.class))).loadClass(ScriptingDriver$.MODULE$.MainClassName());
        return clazz.getMethod(ScriptingDriver$.MODULE$.MainMethodName(), String[].class);
    }

    private final Contexts.Context given_Context$lzyINIT1$1(LazyRef given_Context$lzy1$1, Contexts.Context rootCtx$1, Path outDir$1) {
        Contexts.Context context;
        LazyRef lazyRef = given_Context$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (given_Context$lzy1$1.initialized()) {
                object = given_Context$lzy1$1.value();
            } else {
                Contexts.FreshContext ctx = rootCtx$1.fresh().setSetting(rootCtx$1.settings().outputDir(), (Object)new PlainDirectory(Directory$.MODULE$.apply(outDir$1)));
                object = given_Context$lzy1$1.initialize((Object)(this.verbose ? ctx.setSetting(rootCtx$1.settings().help(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).setSetting(rootCtx$1.settings().XshowPhases(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).setSetting(rootCtx$1.settings().Vhelp(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).setSetting(rootCtx$1.settings().Vprofile(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).setSetting(rootCtx$1.settings().explain(), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : ctx));
            }
            context = (Contexts.Context)object;
        }
        return context;
    }

    private final Contexts.Context given_Context$1(LazyRef given_Context$lzy1$2, Contexts.Context rootCtx$2, Path outDir$2) {
        return (Contexts.Context)(given_Context$lzy1$2.initialized() ? given_Context$lzy1$2.value() : this.given_Context$lzyINIT1$1(given_Context$lzy1$2, rootCtx$2, outDir$2));
    }
}

