/*
 * Decompiled with CFR 0.152.
 */
package replpp.util;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import replpp.Config;
import replpp.Dependencies$;
import replpp.ReplDriver;
import replpp.UsingDirectives$;
import replpp.package$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyBoolean;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class ClasspathHelper$
implements Serializable {
    public static final ClasspathHelper$ MODULE$ = new ClasspathHelper$();

    private ClasspathHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClasspathHelper$.class);
    }

    public String create(Config config, boolean quiet) {
        return this.createAsSeq(config, quiet).mkString(File.pathSeparator, File.pathSeparator, File.pathSeparator);
    }

    public boolean create$default$2() {
        return false;
    }

    public Seq<Path> createAsSeq(Config config, boolean quiet) {
        Builder entries = scala.package$.MODULE$.Seq().newBuilder();
        Object object = Predef$.MODULE$.refArrayOps((Object[])System.getProperty("java.class.path").split(File.pathSeparator));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3))));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$4 -> Paths.get(_$4, new String[0]), ClassTag$.MODULE$.apply(Path.class)));
        ArrayOps$.MODULE$.foreach$extension(object3, (Function1)(JProcedure1 & Serializable)path -> this.addToEntriesMaybe$1(config, quiet, entries, (Path)path));
        ((IterableOnceOps)this.jarsFromClassLoaderRecursively(ReplDriver.class.getClassLoader()).map((Function1 & Serializable)url -> Paths.get(url.toURI()))).foreach((Function1)(JProcedure1 & Serializable)path -> this.addToEntriesMaybe$1(config, quiet, entries, (Path)path));
        Seq scriptLines = (Seq)config.scriptFile().map((Function1 & Serializable)path -> (Seq)Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)_$5 -> _$5.getLines().toSeq(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)).getOrElse(ClasspathHelper$::$anonfun$3);
        Seq<Path> fromDependencies = this.dependencyArtifacts(config, (Seq<String>)scriptLines);
        fromDependencies.foreach((Function1 & Serializable)elem -> (Builder)entries.addOne(elem));
        if (fromDependencies.nonEmpty() && !quiet) {
            Predef$.MODULE$.println((Object)("resolved dependencies - adding " + fromDependencies.size() + " artifact(s) to classpath - to list them, enable verbose mode"));
            if (package$.MODULE$.verboseEnabled(config)) {
                fromDependencies.foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
            }
        }
        Seq allLines = (Seq)package$.MODULE$.allPredefLines(config).$plus$plus((IterableOnce)scriptLines);
        Seq additionalEntries = (Seq)config.classpathConfig().additionalClasspathEntries().$plus$plus(UsingDirectives$.MODULE$.findClasspathEntries((IterableOnce<String>)allLines));
        ((IterableOnceOps)additionalEntries.map((Function1 & Serializable)_$6 -> Paths.get(_$6, new String[0]))).foreach((Function1 & Serializable)elem -> (Builder)entries.addOne(elem));
        return (Seq)((SeqOps)entries.result()).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public boolean createAsSeq$default$2() {
        return false;
    }

    public Seq<Path> dependencyArtifacts(Config config, Seq<String> scriptLines) {
        Seq allLines = (Seq)package$.MODULE$.allPredefLines(config).$plus$plus(scriptLines);
        Seq resolvers = (Seq)config.classpathConfig().resolvers().$plus$plus(UsingDirectives$.MODULE$.findResolvers((IterableOnce<String>)allLines));
        Seq allDependencies = (Seq)config.classpathConfig().dependencies().$plus$plus(UsingDirectives$.MODULE$.findDeclaredDependencies((IterableOnce<String>)allLines));
        return (Seq)Dependencies$.MODULE$.resolve((Seq<String>)allDependencies, (Seq<String>)resolvers, package$.MODULE$.verboseEnabled(config)).get();
    }

    private Seq<URL> jarsFromClassLoaderRecursively(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)classLoader2;
            return (Seq)this.jarsFromClassLoaderRecursively(cl.getParent()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])cl.getURLs()));
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private final boolean excluded$lzyINIT1$1(LazyBoolean excluded$lzy1$1, Config.ForClasspath classpathConfig$1, String filename$2) {
        boolean bl;
        LazyBoolean lazyBoolean = excluded$lzy1$1;
        synchronized (lazyBoolean) {
            bl = excluded$lzy1$1.initialized() ? excluded$lzy1$1.value() : excluded$lzy1$1.initialize(classpathConfig$1.inheritClasspathExcludes().exists((Function1 & Serializable)_$2 -> filename$2.matches((String)_$2)));
        }
        return bl;
    }

    private final boolean excluded$1(LazyBoolean excluded$lzy1$2, Config.ForClasspath classpathConfig$2, String filename$4) {
        if (excluded$lzy1$2.initialized()) {
            return excluded$lzy1$2.value();
        }
        return this.excluded$lzyINIT1$1(excluded$lzy1$2, classpathConfig$2, filename$4);
    }

    private final void addToEntriesMaybe$1(Config config$1, boolean quiet$1, Builder entries$1, Path path) {
        boolean debugPrint;
        LazyBoolean lazyBoolean = new LazyBoolean();
        Config.ForClasspath classpathConfig = config$1.classpathConfig();
        String filename = path.getFileName().toString();
        boolean included = classpathConfig.inheritClasspath() || classpathConfig.inheritClasspathIncludes().exists((Function1 & Serializable)_$1 -> filename.matches((String)_$1));
        boolean bl = debugPrint = package$.MODULE$.verboseEnabled(config$1) && !quiet$1;
        if (included && !this.excluded$1(lazyBoolean, classpathConfig, filename)) {
            if (debugPrint) {
                Predef$.MODULE$.println((Object)("using jar from inherited classpath: " + path));
            }
            entries$1.addOne((Object)path);
            return;
        }
        if (debugPrint) {
            Predef$.MODULE$.println((Object)("exluding jar from inherited classpath (included=" + included + "; excluded=" + this.excluded$1(lazyBoolean, classpathConfig, filename) + ": " + path + ")"));
            return;
        }
    }

    private static final Seq $anonfun$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }
}

