/*
 * Decompiled with CFR 0.152.
 */
package replpp;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import replpp.package$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;

public final class UsingDirectives$
implements Serializable {
    private static final String LibDirective;
    private static final String FileDirective;
    private static final String ResolverDirective;
    private static final String ClasspathDirective;
    public static final UsingDirectives$ MODULE$;

    private UsingDirectives$() {
    }

    static {
        MODULE$ = new UsingDirectives$();
        String Prefix = "//> using";
        LibDirective = Prefix + " dep ";
        FileDirective = Prefix + " file ";
        ResolverDirective = Prefix + " resolver";
        ClasspathDirective = Prefix + " classpath";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UsingDirectives$.class);
    }

    public String LibDirective() {
        return LibDirective;
    }

    public String FileDirective() {
        return FileDirective;
    }

    public String ResolverDirective() {
        return ResolverDirective;
    }

    public String ClasspathDirective() {
        return ClasspathDirective;
    }

    public Seq<Path> findImportedFilesRecursively(Path path, Set<Path> visited) {
        Path rootDir = Files.isDirectory(path, new LinkOption[0]) ? path : path.toAbsolutePath().getParent();
        Seq<Path> importedFiles = this.findImportedFiles((IterableOnce<String>)replpp.util.package$.MODULE$.linesFromFile(path), rootDir);
        Seq recursivelyImportedFiles = (Seq)((IterableOps)importedFiles.filterNot((Function1 & Serializable)elem -> visited.contains(elem))).flatMap((Function1 & Serializable)file -> MODULE$.findImportedFilesRecursively((Path)file, (Set<Path>)((Set)visited.$plus(file))));
        return (Seq)((SeqOps)importedFiles.$plus$plus((IterableOnce)recursivelyImportedFiles)).distinct();
    }

    public Set<Path> findImportedFilesRecursively$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Seq<Path> findImportedFiles(IterableOnce<String> lines, Path rootPath) {
        return this.scanFor(this.FileDirective(), lines).iterator().map((Function1 & Serializable)_$1 -> package$.MODULE$.resolveFile(rootPath, (String)_$1)).toSeq();
    }

    public Seq<String> findDeclaredDependencies(IterableOnce<String> lines) {
        return this.scanFor(this.LibDirective(), lines);
    }

    public Seq<String> findResolvers(IterableOnce<String> lines) {
        return this.scanFor(this.ResolverDirective(), lines);
    }

    public Seq<Path> findClasspathEntriesInLines(IterableOnce<String> sourceLines, Path relativeTo) {
        return (Seq)((IterableOps)this.scanFor(this.ClasspathDirective(), sourceLines).map((Function1 & Serializable)classpathEntry -> {
            Path pathRelativeToDeclaringFile = relativeTo.resolve((String)classpathEntry);
            return Tuple2$.MODULE$.apply(classpathEntry, (Object)pathRelativeToDeclaringFile);
        })).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String classpathEntry = (String)tuple2._1();
                Path pathRelativeToDeclaringFile = (Path)tuple2._2();
                return pathRelativeToDeclaringFile;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<Path> findClasspathEntriesInFiles(IterableOnce<Path> files) {
        return files.iterator().flatMap((Function1 & Serializable)file -> {
            Path dir = file.getParent();
            return MODULE$.findClasspathEntriesInLines((IterableOnce<String>)replpp.util.package$.MODULE$.linesFromFile((Path)file), dir);
        }).toSeq();
    }

    private Seq<String> scanFor(String directive, IterableOnce<String> lines) {
        return lines.iterator().map((Function1 & Serializable)_$2 -> _$2.trim()).filter((Function1 & Serializable)_$3 -> _$3.startsWith(directive)).map((Function1 & Serializable)_$4 -> StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$4), directive.length()).trim()).toSeq();
    }
}

