/*
 * Decompiled with CFR 0.152.
 */
package replpp.scripting;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import replpp.Config;
import replpp.Config$;
import replpp.package$;
import replpp.scripting.ScriptingDriver;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class NonForkingScriptRunner$
implements Serializable {
    public static final NonForkingScriptRunner$ MODULE$ = new NonForkingScriptRunner$();

    private NonForkingScriptRunner$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NonForkingScriptRunner$.class);
    }

    public void main(String[] args) {
        Config config = Config$.MODULE$.parse(args);
        this.exec(config);
    }

    public void exec(Config config) {
        Path scriptFile = (Path)config.scriptFile().getOrElse(NonForkingScriptRunner$::$anonfun$1);
        if (!Files.exists(scriptFile, new LinkOption[0])) {
            throw new AssertionError((Object)("given script file " + scriptFile + " does not exist"));
        }
        String paramsInfoMaybe = config.params().nonEmpty() ? " with params=" + config.params() : "";
        System.err.println("executing " + scriptFile + paramsInfoMaybe);
        List commandArgs = config.command().toList();
        Iterable parameterArgs = (Iterable)config.params().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return (Seq)((SeqOps)new .colon.colon((Object)("--" + key), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq scriptArgs = (Seq)commandArgs.$plus$plus((IterableOnce)parameterArgs);
        boolean verboseEnabled = package$.MODULE$.verboseEnabled(config);
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.compilerArgs(config));
        Try<BoxedUnit> try_ = new ScriptingDriver((String[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)"-nowarn", ClassTag$.MODULE$.apply(String.class)), package$.MODULE$.allPredefFiles(config), config.runBefore(), scriptFile, (String[])scriptArgs.toArray(ClassTag$.MODULE$.apply(String.class)), verboseEnabled).compileAndRun();
        if (try_ instanceof Success) {
            if (verboseEnabled) {
                System.err.println("script finished successfully");
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            System.err.println("error during script execution: " + exception.getMessage());
            throw exception;
        }
        throw new MatchError(try_);
    }

    private static final Path $anonfun$1() {
        throw new AssertionError((Object)"script file not defined - please specify e.g. via `--script=myscript.sc`");
    }
}

