/*
 * Decompiled with CFR 0.152.
 */
package com.mickaelb.integration.spring;

import com.mickaelb.api.AssertHibernateSQLCount;
import com.mickaelb.integration.hibernate.HibernateStatementInspector;
import com.mickaelb.integration.hibernate.HibernateStatementStatistics;
import com.mickaelb.integration.spring.AssertTestListener;
import com.mickaelb.integration.spring.assertions.sql.HibernateStatementAssertionResult;
import com.mickaelb.integration.spring.assertions.sql.HibernateStatementAssertionResults;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.transaction.TestTransaction;

public class HibernateSQLCountTestListener
implements AssertTestListener {
    private Supplier<HibernateStatementStatistics> statisticsSupplier = HibernateStatementInspector::getStatistics;
    private Supplier<Boolean> transactionAvailabilitySupplier = TestTransaction::isActive;

    @Override
    public void beforeTestClass(TestContext testContext) {
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        AssertHibernateSQLCount sqlCountAnnotation = testContext.getTestMethod().getAnnotation(AssertHibernateSQLCount.class);
        if (sqlCountAnnotation != null) {
            this.statisticsSupplier.get().resetStatistics();
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        AssertHibernateSQLCount sqlCountAnnotation = testContext.getTestMethod().getAnnotation(AssertHibernateSQLCount.class);
        if (sqlCountAnnotation != null) {
            this.flushExistingPersistenceContext(testContext, this.transactionAvailabilitySupplier);
            this.evaluateSQLStatementCount(sqlCountAnnotation);
        }
    }

    private void flushExistingPersistenceContext(TestContext testContext, Supplier<Boolean> transactionAvailabilitySupplier) {
        if (transactionAvailabilitySupplier.get().booleanValue()) {
            EntityManager entityManager = (EntityManager)testContext.getApplicationContext().getAutowireCapableBeanFactory().getBean(EntityManager.class);
            entityManager.flush();
        }
    }

    private void evaluateSQLStatementCount(AssertHibernateSQLCount annotation) {
        HibernateStatementAssertionResults assertionResults = new HibernateStatementAssertionResults(List.of(new HibernateStatementAssertionResult(HibernateStatementAssertionResult.StatementType.SELECT, this.statisticsSupplier.get().getSelectStatements(), annotation.selects()), new HibernateStatementAssertionResult(HibernateStatementAssertionResult.StatementType.UPDATE, this.statisticsSupplier.get().getUpdateStatements(), annotation.updates()), new HibernateStatementAssertionResult(HibernateStatementAssertionResult.StatementType.INSERT, this.statisticsSupplier.get().getInsertStatements(), annotation.inserts()), new HibernateStatementAssertionResult(HibernateStatementAssertionResult.StatementType.DELETE, this.statisticsSupplier.get().getDeleteStatements(), annotation.deletes())));
        assertionResults.validate();
    }
}

