/*
 * Decompiled with CFR 0.152.
 */
package com.mickaelb.integration.spring.assertions.l2c;

import com.mickaelb.integration.spring.assertions.HibernateAssertCountException;
import com.mickaelb.integration.spring.assertions.HibernateStatementAssertionValidator;

public class HibernateL2CAssertionResult
implements HibernateStatementAssertionValidator {
    private CacheAction type;
    private long actual;
    private long expected;

    public HibernateL2CAssertionResult(CacheAction type, long actual, long expected) {
        this.type = type;
        this.actual = actual;
        this.expected = expected;
    }

    public boolean isInError() {
        return this.actual != this.expected;
    }

    public String getErrorMessage() {
        return "Expected " + this.expected + " L2C cache " + this.type.name() + " but got " + this.actual;
    }

    @Override
    public void validate() {
        if (this.isInError()) {
            throw new HibernateAssertCountException(this.getErrorMessage());
        }
    }

    public static enum CacheAction {
        HIT,
        MISS,
        PUT;

    }
}

