/*
 * Decompiled with CFR 0.152.
 */
package com.mickaelb.api;

import com.mickaelb.api.StatementType;
import com.mickaelb.integration.hibernate.HibernateStatementInspector;
import com.mickaelb.integration.spring.assertions.sql.HibernateStatementAssertionResult;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class QueryAssertions {
    private static final Map<StatementType, Supplier<List<String>>> STATEMENT_SUPPLIERS = Map.of(StatementType.INSERT, () -> HibernateStatementInspector.getStatistics().getInsertStatements(), StatementType.UPDATE, () -> HibernateStatementInspector.getStatistics().getUpdateStatements(), StatementType.SELECT, () -> HibernateStatementInspector.getStatistics().getSelectStatements(), StatementType.DELETE, () -> HibernateStatementInspector.getStatistics().getDeleteStatements());

    private QueryAssertions() {
    }

    public static void assertInsertCount(int expectedInsertCount, Runnable runnable) {
        QueryAssertions.doAssertStatementCount(runnable, StatementType.INSERT, expectedInsertCount);
    }

    public static void assertUpdateCount(int expectedUpdateCount, Runnable runnable) {
        QueryAssertions.doAssertStatementCount(runnable, StatementType.UPDATE, expectedUpdateCount);
    }

    public static void assertSelectCount(int expectedSelectCount, Runnable runnable) {
        QueryAssertions.doAssertStatementCount(runnable, StatementType.SELECT, expectedSelectCount);
    }

    public static void assertDeleteCount(int expectedDeleteCount, Runnable runnable) {
        QueryAssertions.doAssertStatementCount(runnable, StatementType.DELETE, expectedDeleteCount);
    }

    public static void assertStatementCount(Map<StatementType, Integer> expectedCounts, Runnable runnable) {
        Map<StatementType, Integer> sizesBeforeExecution = expectedCounts.keySet().stream().collect(Collectors.toMap(statementType -> statementType, statementType -> STATEMENT_SUPPLIERS.get(statementType).get().size()));
        runnable.run();
        for (Map.Entry<StatementType, Integer> entry : expectedCounts.entrySet()) {
            StatementType statementType2 = entry.getKey();
            int expectedCount = entry.getValue();
            Supplier<List<String>> statementSupplier = STATEMENT_SUPPLIERS.get((Object)statementType2);
            List<String> fullStatements = statementSupplier.get();
            int sizeBeforeExecution = sizesBeforeExecution.get((Object)statementType2);
            List<String> executionScopedStatements = fullStatements.subList(sizeBeforeExecution, fullStatements.size());
            HibernateStatementAssertionResult assertionResult = new HibernateStatementAssertionResult(statementType2, executionScopedStatements, expectedCount);
            assertionResult.validate();
        }
    }

    private static void doAssertStatementCount(Runnable runnable, StatementType statementType, int expectedCount) {
        Supplier<List<String>> statementSupplier = STATEMENT_SUPPLIERS.get((Object)statementType);
        int sizeBeforeExecution = statementSupplier.get().size();
        runnable.run();
        List<String> fullStatements = statementSupplier.get();
        List<String> executionScopedStatements = fullStatements.subList(sizeBeforeExecution, fullStatements.size());
        HibernateStatementAssertionResult assertionResult = new HibernateStatementAssertionResult(statementType, executionScopedStatements, expectedCount);
        assertionResult.validate();
    }
}

